/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.command;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.api.util.Tristate;

public class SourceChoicesElement
extends CommandElement {
    private static final int CUTOFF = 5;
    private final Function<CommandSource, Collection<String>> keySupplier;
    private final BiFunction<CommandSource, String, ?> valueSupplier;
    private final Tristate choicesInUsage;

    SourceChoicesElement(Text key, Function<CommandSource, Collection<String>> keySupplier, BiFunction<CommandSource, String, ?> valueSupplier, Tristate choicesInUsage) {
        super(key);
        this.keySupplier = keySupplier;
        this.valueSupplier = valueSupplier;
        this.choicesInUsage = choicesInUsage;
    }

    public Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        Object value = this.valueSupplier.apply(source, args.next());
        if (value == null) {
            throw args.createError(SpongeApiTranslationHelper.t((String)"Argument was not a valid choice. Valid choices: %s", (Object[])new Object[]{this.keySupplier.apply(source).toString()}));
        }
        return value;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        String prefix = args.nextIfPresent().orElse("");
        return (List)this.keySupplier.apply(src).stream().filter((Predicate<String>)new StartsWithPredicate(prefix)).collect(ImmutableList.toImmutableList());
    }

    public Text getUsage(CommandSource commander) {
        Collection<String> keys = this.keySupplier.apply(commander);
        if (this.choicesInUsage == Tristate.TRUE || this.choicesInUsage == Tristate.UNDEFINED && keys.size() <= 5) {
            Text.Builder build = Text.builder();
            build.append(new Text[]{CommandMessageFormatting.LT_TEXT});
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                build.append(new Text[]{Text.of((String)it.next())});
                if (!it.hasNext()) continue;
                build.append(new Text[]{CommandMessageFormatting.PIPE_TEXT});
            }
            build.append(new Text[]{CommandMessageFormatting.GT_TEXT});
            return build.build();
        }
        return super.getUsage(commander);
    }
}

