/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.rentableregions.data;

import com.google.common.collect.Lists;
import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionRole;
import com.universeguard.utils.RegionUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import pw.aaron1011.rentableregions.RentableRegions;
import pw.aaron1011.rentableregions.data.LocationData;

@ConfigSerializable
public class RentedRegion {
    @Setting(value="name")
    public String name;
    @Setting(value="duration")
    private Duration duration;
    @Setting(value="owner")
    public UUID owner;
    @Setting(value="end-time")
    public Instant endTime;
    @Setting(value="start-time")
    public Instant startTime;
    @Setting(value="price")
    public BigDecimal price;
    @Setting(value="added-players")
    public Set<UUID> addedPlayers = new HashSet<UUID>();
    @Setting(value="signs")
    public List<LocationData> signs = new ArrayList<LocationData>();
    @Setting(value="new-duration")
    private Duration newDuration;
    @Setting(value="new-price")
    private BigDecimal newPrice;

    public RentedRegion() {
    }

    public void checkRented() {
        if (this.owner == null) {
            return;
        }
        if (Instant.now().isAfter(this.endTime)) {
            RentableRegions.stopRenting(this.owner, this, false);
        }
    }

    public boolean isRented() {
        this.checkRented();
        return this.owner != null;
    }

    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.endTime);
    }

    public Duration getRentalLength() {
        return this.duration;
    }

    public Duration getRemainingTime() {
        if (this.startTime != null) {
            Instant now = Instant.now();
            if (now.isAfter(this.endTime)) {
                return Duration.ZERO;
            }
            return Duration.between(now, this.endTime);
        }
        return this.duration;
    }

    public RentedRegion(String name, Duration duration, BigDecimal price, LocationData initialSign) {
        this.name = name;
        this.duration = duration;
        this.price = price;
        this.signs = Lists.newArrayList((Object[])new LocationData[]{initialSign});
    }

    public void updateTimeAndDuration() {
        boolean updated = false;
        if (this.newDuration != null) {
            this.duration = this.newDuration;
            this.newDuration = null;
            updated = true;
        }
        if (this.newPrice != null) {
            this.price = this.newPrice;
            this.newPrice = null;
            updated = true;
        }
        if (updated) {
            RentableRegions.INSTANCE.saveRegionsData();
        }
    }

    public void setRentedBy(Player src) {
        this.owner = src.getUniqueId();
        this.startTime = Instant.now();
        this.endTime = this.startTime.plus(this.duration);
    }

    public void removeSign(Location<World> location) {
        LocationData locationData = new LocationData(location);
        this.signs.remove(locationData);
        RentableRegions.getRegionsData().removeFromCache(locationData);
        RentableRegions.INSTANCE.saveRegionsData();
    }

    public void addMember(User user, boolean store) {
        Region region;
        if (store) {
            this.addedPlayers.add(user.getUniqueId());
        }
        if ((region = RegionUtils.load((String)this.name)) == null) {
            throw new IllegalStateException("Unable to load region " + this.name);
        }
        ((LocalRegion)region).addMemberByUUIDAndUsername(user.getUniqueId(), user.getName(), RegionRole.MEMBER);
        RentableRegions.INSTANCE.saveRegionsData();
    }

    public void removeMember(UUID user, boolean store) {
        Region region;
        if (store) {
            this.addedPlayers.remove(user);
        }
        if ((region = RegionUtils.load((String)this.name)) == null) {
            throw new IllegalStateException("Unable to load region " + this.name);
        }
        ((LocalRegion)region).removeMemberByUUID(user);
        if (!RegionUtils.save((Region)region)) {
            RentableRegions.INSTANCE.logger.error("Failed to save region " + this.name);
        }
        RentableRegions.INSTANCE.saveRegionsData();
    }

    public void setNewDuration(Duration duration) {
        if (this.isRented()) {
            this.newDuration = duration;
        } else {
            this.duration = duration;
            RentableRegions.INSTANCE.refreshSigns(this);
        }
        RentableRegions.INSTANCE.saveRegionsData();
    }

    public void setNewPrice(BigDecimal price) {
        if (this.isRented()) {
            this.newPrice = price;
        } else {
            this.price = price;
            RentableRegions.INSTANCE.refreshSigns(this);
        }
        RentableRegions.INSTANCE.saveRegionsData();
    }
}

