/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser.StandardParser;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;

public class CatalogTypeParser<T extends CatalogType>
extends StandardParser<T> {
    private final Class<T> type;

    public CatalogTypeParser(Class<T> type, ImmutableMap<String, String> messages) {
        super(messages);
        this.type = type;
    }

    @Override
    public T parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        return (T)((CatalogType)Sponge.getRegistry().getType(this.type, arg).orElseThrow(() -> args.createError(this.getMessage("no-type", "Input <arg> is not a registered <type>.", "arg", arg, "type", this.type.getSimpleName()))));
    }

    @Override
    public ImmutableList<String> complete(CommandSource src, CommandArgs args, CommandContext ctx) {
        return CatalogTypeParser.complete(args, Sponge.getRegistry().getAllOf(this.type).stream().map(CatalogType::getId));
    }
}

