/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.commands;

import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Config.Messages;
import net.moddedminecraft.mmcreboot.Main;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;

public class RebootTime
implements CommandExecutor {
    private final Main plugin;

    public RebootTime(Main instance) {
        this.plugin = instance;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!this.plugin.tasksScheduled) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNoTaskScheduled()));
        }
        if (Config.restartType.equalsIgnoreCase("fixed") || Config.restartInterval > 0.0 && this.plugin.isRestarting && (this.plugin.nextRealTimeRestart > Config.restartInterval || this.plugin.nextRealTimeRestart == 0.0)) {
            double timeLeft = Config.restartInterval * 3600.0 - (double)(System.currentTimeMillis() - this.plugin.startTimestamp) / 1000.0;
            int hours = (int)(timeLeft / 3600.0);
            int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
            int seconds = (int)timeLeft % 60;
            this.plugin.sendMessage(src, Messages.getRestartMessageWithoutReason().replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes)).replace("%seconds%", String.valueOf(seconds)));
            return CommandResult.success();
        }
        if (Config.restartType.equalsIgnoreCase("realtime")) {
            double timeLeft = this.plugin.nextRealTimeRestart - (double)(System.currentTimeMillis() - this.plugin.startTimestamp) / 1000.0;
            int hours = (int)(timeLeft / 3600.0);
            int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
            int seconds = (int)timeLeft % 60;
            this.plugin.sendMessage(src, Messages.getRestartMessageWithoutReason().replace("%hours%", String.valueOf(hours)).replace("%minutes%", String.valueOf(minutes)).replace("%seconds%", String.valueOf(seconds)));
            return CommandResult.success();
        }
        throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNoTaskScheduled()));
    }
}

