/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.manager;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.delegates.manager.ApiAbstractManager;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparisons.StandardComparison;
import me.lucko.luckperms.common.managers.user.UserManager;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApiUserManager
extends ApiAbstractManager<User, me.lucko.luckperms.api.User, UserManager<?>>
implements me.lucko.luckperms.api.manager.UserManager {
    public ApiUserManager(LuckPermsPlugin plugin, UserManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected me.lucko.luckperms.api.User getDelegateFor(User internal) {
        if (internal == null) {
            return null;
        }
        return new ApiUser(internal);
    }

    @Override
    public @NonNull CompletableFuture<me.lucko.luckperms.api.User> loadUser(@NonNull UUID uuid, @Nullable String username) {
        Objects.requireNonNull(uuid, "uuid");
        ApiUtils.checkUsername(username);
        if (this.plugin.getUserManager().getIfLoaded(uuid) == null) {
            this.plugin.getUserManager().getHouseKeeper().registerApiUsage(uuid);
        }
        return this.plugin.getStorage().loadUser(uuid, username).thenApply(this::getDelegateFor);
    }

    @Override
    public @NonNull CompletableFuture<UUID> lookupUuid(@NonNull String username) {
        Objects.requireNonNull(username, "username");
        return this.plugin.getStorage().getPlayerUuid(username);
    }

    @Override
    public @NonNull CompletableFuture<String> lookupUsername(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return this.plugin.getStorage().getPlayerName(uuid);
    }

    @Override
    public @NonNull CompletableFuture<Void> saveUser(@NonNull me.lucko.luckperms.api.User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getStorage().saveUser(ApiUser.cast(user));
    }

    @Override
    public @NonNull CompletableFuture<PlayerSaveResult> savePlayerData(@NonNull UUID uuid, @NonNull String username) {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(username, "username");
        return this.plugin.getStorage().savePlayerData(uuid, username);
    }

    @Override
    public @NonNull CompletableFuture<Set<UUID>> getUniqueUsers() {
        return this.plugin.getStorage().getUniqueUsers();
    }

    @Override
    public @NonNull CompletableFuture<List<HeldPermission<UUID>>> getWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.plugin.getStorage().getUsersWithPermission(Constraint.of(StandardComparison.EQUAL, permission));
    }

    @Override
    public me.lucko.luckperms.api.User getUser(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return this.getDelegateFor((User)((UserManager)this.handle).getIfLoaded(uuid));
    }

    @Override
    public me.lucko.luckperms.api.User getUser(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.getDelegateFor((User)((UserManager)this.handle).getByUsername(name));
    }

    @Override
    public @NonNull Set<me.lucko.luckperms.api.User> getLoadedUsers() {
        return (Set)((UserManager)this.handle).getAll().values().stream().map(this::getDelegateFor).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return ((UserManager)this.handle).isLoaded(UserIdentifier.of(uuid, null));
    }

    @Override
    public void cleanupUser(@NonNull me.lucko.luckperms.api.User user) {
        Objects.requireNonNull(user, "user");
        ((UserManager)this.handle).getHouseKeeper().clearApiUsage(ApiUser.cast(user).getUuid());
    }
}

