/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.misc;

import java.util.Map;
import me.lucko.luckperms.api.LPConfiguration;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.common.config.ConfigKey;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiConfiguration
implements LPConfiguration {
    private final LuckPermsConfiguration handle;
    private final LPConfiguration.Unsafe unsafe;

    public ApiConfiguration(LuckPermsConfiguration handle) {
        this.handle = handle;
        this.unsafe = new UnsafeImpl();
    }

    @Override
    public @NonNull String getServer() {
        return this.handle.get(ConfigKeys.SERVER);
    }

    @Override
    public boolean getIncludeGlobalPerms() {
        return this.handle.get(ConfigKeys.LOOKUP_SETTINGS).contains((Object)LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER);
    }

    @Override
    public boolean getIncludeGlobalWorldPerms() {
        return this.handle.get(ConfigKeys.LOOKUP_SETTINGS).contains((Object)LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD);
    }

    @Override
    public boolean getApplyGlobalGroups() {
        return this.handle.get(ConfigKeys.LOOKUP_SETTINGS).contains((Object)LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER);
    }

    @Override
    public boolean getApplyGlobalWorldGroups() {
        return this.handle.get(ConfigKeys.LOOKUP_SETTINGS).contains((Object)LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
    }

    @Override
    public @NonNull String getStorageMethod() {
        return this.handle.get(ConfigKeys.STORAGE_METHOD);
    }

    @Override
    public boolean getSplitStorage() {
        return this.handle.get(ConfigKeys.SPLIT_STORAGE);
    }

    @Override
    public @NonNull Map<String, String> getSplitStorageOptions() {
        return (Map)this.handle.get(ConfigKeys.SPLIT_STORAGE_OPTIONS).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((SplitStorageType)((Object)((Object)e.getKey()))).name().toLowerCase(), Map.Entry::getValue));
    }

    @Override
    public @NonNull LPConfiguration.Unsafe unsafe() {
        return this.unsafe;
    }

    private final class UnsafeImpl
    implements LPConfiguration.Unsafe {
        private UnsafeImpl() {
        }

        @Override
        public @NonNull Object getObject(String key) {
            ConfigKey<?> configKey = ConfigKeys.getKeys().get(key.toUpperCase());
            if (configKey == null) {
                throw new IllegalArgumentException("Unknown key: " + key);
            }
            return ApiConfiguration.this.handle.get(configKey);
        }
    }
}

