/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.query;

import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.bulkupdate.query.QueryField;
import me.lucko.luckperms.common.node.model.NodeDataContainer;

public class Query {
    private final QueryField field;
    private final Constraint constraint;

    public static Query of(QueryField field, Constraint constraint) {
        return new Query(field, constraint);
    }

    private Query(QueryField field, Constraint constraint) {
        this.field = field;
        this.constraint = constraint;
    }

    public boolean isSatisfiedBy(NodeDataContainer node) {
        switch (this.field) {
            case PERMISSION: {
                return this.constraint.eval(node.getPermission());
            }
            case SERVER: {
                return this.constraint.eval(node.getServer());
            }
            case WORLD: {
                return this.constraint.eval(node.getWorld());
            }
        }
        throw new RuntimeException();
    }

    public void appendSql(PreparedStatementBuilder builder) {
        this.constraint.appendSql(builder, this.field.getSqlName());
    }

    public QueryField getField() {
        return this.field;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }
}

