/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.Multimap;
import java.util.List;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Predicates;

public class GroupClone
extends SubCommand<Group> {
    public GroupClone(LocaleManager locale) {
        super(CommandSpec.GROUP_CLONE.localize(locale), "clone", CommandPermission.GROUP_CLONE, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        String newGroupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(newGroupName)) {
            Message.GROUP_INVALID_ENTRY.send(sender, newGroupName);
            return CommandResult.INVALID_ARGS;
        }
        Group newGroup = plugin.getStorage().createAndLoadGroup(newGroupName, CreationCause.COMMAND).join();
        if (newGroup == null) {
            Message.GROUP_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), newGroup)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        newGroup.replaceNodes(NodeMapType.ENDURING, (Multimap<ImmutableContextSet, ? extends Node>)group.enduringData().immutable());
        Message.CLONE_SUCCESS.send(sender, group.getName(), newGroup.getName());
        ExtendedLogEntry.build().actor(sender).acted(newGroup).action("clone", group.getName()).build().submit(plugin, sender);
        StorageAssistant.save(newGroup, sender, plugin);
        return CommandResult.SUCCESS;
    }
}

