/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Paginated;
import me.lucko.luckperms.common.utils.Predicates;

public class LogSearch
extends SubCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogSearch(LocaleManager locale) {
        super(CommandSpec.LOG_SEARCH.localize(locale), "search", CommandPermission.LOG_SEARCH, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        int page = Integer.MIN_VALUE;
        if (args.size() > 1) {
            try {
                page = Integer.parseInt(args.get(args.size() - 1));
                args.remove(args.size() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String query = args.stream().collect(Collectors.joining(" "));
        Paginated<ExtendedLogEntry> content = new Paginated<ExtendedLogEntry>(log.getSearch(query));
        if (page != Integer.MIN_VALUE) {
            return LogSearch.showLog(page, query, sender, content);
        }
        return LogSearch.showLog(content.getMaxPages(10), query, sender, content);
    }

    private static CommandResult showLog(int page, String query, Sender sender, Paginated<ExtendedLogEntry> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (page == Integer.MIN_VALUE) {
            page = maxPage;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        SortedMap<Integer, ExtendedLogEntry> entries = log.getPage(page, 10);
        Message.LOG_SEARCH_HEADER.send(sender, query, page, maxPage);
        long now = System.currentTimeMillis() / 1000L;
        for (Map.Entry<Integer, ExtendedLogEntry> e : entries.entrySet()) {
            long time = e.getValue().getTimestamp();
            Message.LOG_ENTRY.send(sender, e.getKey(), DurationFormatter.CONCISE_LOW_ACCURACY.format(now - time), e.getValue().getActorFriendlyString(), Character.toString(e.getValue().getType().getCode()), e.getValue().getActedFriendlyString(), e.getValue().getAction());
        }
        return CommandResult.SUCCESS;
    }
}

