/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.StaticContextCalculator;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import me.lucko.luckperms.common.caching.type.MetaCache;
import me.lucko.luckperms.common.caching.type.PermissionCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.contexts.ContextSetJsonSerializer;
import me.lucko.luckperms.common.contexts.ProxiedContextCalculator;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.processors.PermissionProcessor;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.utils.gson.GsonProvider;
import me.lucko.luckperms.common.utils.gson.JArray;
import me.lucko.luckperms.common.utils.gson.JObject;
import me.lucko.luckperms.common.web.Pastebin;
import me.lucko.luckperms.common.web.StandardPastebin;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class DebugCommand
extends SingleCommand {
    public DebugCommand(LocaleManager locale) {
        super(CommandSpec.DEBUG.localize(locale), "Debug", CommandPermission.DEBUG, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        Message.DEBUG_START.send(sender, new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("LuckPerms Debug Output\n\n\n");
        BiConsumer<String, JObject> builder = (name, content) -> {
            sb.append("-- ").append((String)name).append(" --\n");
            sb.append(GsonProvider.prettyPrinting().toJson((JsonElement)content.toJson()));
            sb.append("\n\n");
        };
        builder.accept("platform.json", DebugCommand.getPlatformData(plugin));
        builder.accept("storage.json", DebugCommand.getStorageData(plugin));
        builder.accept("context.json", DebugCommand.getContextData(plugin));
        builder.accept("players.json", DebugCommand.getPlayersData(plugin));
        Pastebin.Paste paste = StandardPastebin.HASTEBIN.postPlain(sb.toString());
        Message.DEBUG_URL.send(sender, new Object[0]);
        TextComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)paste.url()).color(TextColor.AQUA)).clickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(paste.url())))).hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Click to open the debugging data.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }

    private static JObject getPlatformData(LuckPermsPlugin plugin) {
        return new JObject().add("type", plugin.getBootstrap().getType().name()).add("version", new JObject().add("api", String.valueOf(plugin.getApiProvider().getPlatformInfo().getApiVersion())).add("plugin", plugin.getBootstrap().getVersion())).add("server", new JObject().add("brand", plugin.getBootstrap().getServerBrand()).add("version", plugin.getBootstrap().getServerVersion()));
    }

    private static JObject getStorageData(LuckPermsPlugin plugin) {
        return new JObject().add("storage", new JObject().add("name", plugin.getStorage().getName()).add("type", plugin.getStorage().getImplementation().getClass().getName()).add("meta", () -> {
            JObject metaObject = new JObject();
            Map<String, String> meta = plugin.getStorage().getMeta();
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                metaObject.add(entry.getKey(), entry.getValue());
            }
            return metaObject;
        })).add("messaging", () -> {
            JObject messaging = new JObject();
            plugin.getMessagingService().ifPresent(ms -> {
                messaging.add("name", ms.getName());
                messaging.add("implementation", new JObject().add("messenger", ms.getMessenger().getClass().getName()).add("provider", ms.getMessengerProvider().getClass().getName()));
            });
            return messaging;
        });
    }

    private static JObject getContextData(LuckPermsPlugin plugin) {
        return new JObject().add("staticContext", (JsonElement)ContextSetJsonSerializer.serializeContextSet(plugin.getContextManager().getStaticContext())).add("calculators", () -> {
            JArray calculators = new JArray();
            for (ContextCalculator<?> calculator : plugin.getContextManager().getCalculators()) {
                String name = calculator.getClass().getName();
                if (calculator instanceof ProxiedContextCalculator) {
                    name = ((ProxiedContextCalculator)calculator).getDelegate().getClass().getName();
                }
                calculators.add(name);
            }
            return calculators;
        }).add("staticCalculators", () -> {
            JArray staticCalculators = new JArray();
            for (StaticContextCalculator calculator : plugin.getContextManager().getStaticCalculators()) {
                staticCalculators.add(calculator.getClass().getName());
            }
            return staticCalculators;
        });
    }

    private static JObject getPlayersData(LuckPermsPlugin plugin) {
        JObject ret = new JObject();
        Set onlinePlayers = plugin.getBootstrap().getOnlinePlayers().collect(Collectors.toSet());
        ret.add("count", onlinePlayers.size());
        JArray playerArray = new JArray();
        for (UUID uuid : onlinePlayers) {
            User user = plugin.getUserManager().getIfLoaded(uuid);
            if (user == null) {
                playerArray.add(new JObject().add("uniqueId", uuid.toString()).add("loaded", false));
                continue;
            }
            playerArray.add(new JObject().add("uniqueId", uuid.toString()).add("loaded", true).add("username", user.getName().orElse("null")).add("primaryGroup", new JObject().add("type", user.getPrimaryGroup().getClass().getName()).add("value", user.getPrimaryGroup().getValue()).add("storedValue", user.getPrimaryGroup().getStoredValue().orElse("null"))).add("activeContext", () -> {
                JObject obj = new JObject();
                Contexts contexts = plugin.getContextForUser(user).orElse(null);
                if (contexts != null) {
                    MetaContexts metaContexts = plugin.getContextManager().formMetaContexts(contexts);
                    obj.add("data", new JObject().add("permissions", DebugCommand.serializePermissionsData(user.getCachedData().getPermissionData(contexts))).add("meta", DebugCommand.serializeMetaData(user.getCachedData().getMetaData(metaContexts)))).add("contextSet", (JsonElement)ContextSetJsonSerializer.serializeContextSet(contexts.getContexts())).add("settings", DebugCommand.serializeContextsSettings(contexts)).add("metaSettings", DebugCommand.serializeMetaContextsSettings(metaContexts));
                }
                return obj;
            }));
        }
        ret.add("players", playerArray);
        return ret;
    }

    private static JArray serializeContextsSettings(Contexts contexts) {
        JArray array = new JArray();
        for (LookupSetting setting : contexts.getSettings()) {
            array.add(setting.name());
        }
        return array;
    }

    private static JObject serializeMetaContextsSettings(MetaContexts metaContexts) {
        return new JObject().add("prefixStack", DebugCommand.serializeMetaStackData(metaContexts.getPrefixStackDefinition())).add("suffixStack", DebugCommand.serializeMetaStackData(metaContexts.getSuffixStackDefinition()));
    }

    private static JObject serializePermissionsData(PermissionCache permissionData) {
        return new JObject().add("processors", () -> {
            JArray processors = new JArray();
            for (PermissionProcessor processor : permissionData.getCalculator().getProcessors()) {
                processors.add(processor.getClass().getName());
            }
            return processors;
        });
    }

    private static JObject serializeMetaData(MetaCache metaData) {
        return new JObject().add("prefix", metaData.getPrefix()).add("suffix", metaData.getSuffix()).add("prefixes", () -> {
            JArray prefixes = new JArray();
            for (Map.Entry<Integer, String> entry : metaData.getPrefixes().entrySet()) {
                prefixes.add(new JObject().add("weight", entry.getKey()).add("value", entry.getValue()));
            }
            return prefixes;
        }).add("suffixes", () -> {
            JArray suffixes = new JArray();
            for (Map.Entry<Integer, String> entry : metaData.getSuffixes().entrySet()) {
                suffixes.add(new JObject().add("weight", entry.getKey()).add("value", entry.getValue()));
            }
            return suffixes;
        }).add("meta", () -> {
            JObject metaMap = new JObject();
            for (Map.Entry<String, String> entry : metaData.getMeta().entrySet()) {
                metaMap.add(entry.getKey(), entry.getValue());
            }
            return metaMap;
        }).add("metaMap", () -> {
            JObject metaMultimap = new JObject();
            for (Map.Entry entry : metaData.getMetaMultimap().asMap().entrySet()) {
                JArray values = new JArray();
                for (String v : (Collection)entry.getValue()) {
                    values.add(v);
                }
                metaMultimap.add((String)entry.getKey(), values);
            }
            return metaMultimap;
        });
    }

    private static JObject serializeMetaStackData(MetaStackDefinition definition) {
        return new JObject().add("type", definition.getClass().getName()).add("startSpacer", definition.getStartSpacer()).add("middleSpacer", definition.getMiddleSpacer()).add("endSpacer", definition.getEndSpacer()).add("elements", () -> {
            JArray elements = new JArray();
            for (MetaStackElement element : definition.getElements()) {
                elements.add(new JObject().add("type", element.getClass().getName()).add("info", element.toString()));
            }
            return elements;
        });
    }
}

