/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.common.web.StandardPastebin;
import me.lucko.luckperms.common.web.WebEditor;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;

public class EditorCommand
extends SingleCommand {
    public EditorCommand(LocaleManager locale) {
        super(CommandSpec.EDITOR.localize(locale), "Editor", CommandPermission.EDITOR, Predicates.notInRange(0, 1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        Type type = Type.ALL;
        String typeString = ArgumentParser.parseStringOrElse(0, args, null);
        if (typeString != null) {
            try {
                type = Type.valueOf(typeString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ArrayList<PermissionHolder> holders = new ArrayList<PermissionHolder>();
        if (type.includingGroups) {
            plugin.getGroupManager().getAll().values().stream().sorted((o1, o2) -> {
                int i = Integer.compare(o2.getWeight().orElse(0), o1.getWeight().orElse(0));
                return i != 0 ? i : o1.getName().compareToIgnoreCase(o2.getName());
            }).forEach(holders::add);
        }
        if (type.includingUsers) {
            plugin.getUserManager().getAll().values().stream().sorted((o1, o2) -> o1.getFormattedDisplayName().compareToIgnoreCase(o2.getFormattedDisplayName())).forEach(holders::add);
        }
        if (holders.isEmpty()) {
            Message.EDITOR_NO_MATCH.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        holders.removeIf(holder -> ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), holder));
        if (holders.isEmpty()) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message.EDITOR_START.send(sender, new Object[0]);
        JsonObject payload = WebEditor.formPayload(holders, sender, label, plugin);
        String pasteId = StandardPastebin.BYTEBIN.postJson((JsonElement)payload, true).id();
        if (pasteId == null) {
            Message.EDITOR_UPLOAD_FAILURE.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.WEB_EDITOR_URL_PATTERN) + "?" + pasteId;
        Message.EDITOR_URL.send(sender, new Object[0]);
        TextComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url))).hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Click to open the editor.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }

    private static enum Type {
        ALL(true, true),
        USERS(true, false),
        GROUPS(false, true);

        private final boolean includingUsers;
        private final boolean includingGroups;

        private Type(boolean includingUsers, boolean includingGroups) {
            this.includingUsers = includingUsers;
            this.includingGroups = includingGroups;
        }
    }
}

