/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Predicates;

public class CreateTrack
extends SingleCommand {
    public CreateTrack(LocaleManager locale) {
        super(CommandSpec.CREATE_TRACK.localize(locale), "CreateTrack", CommandPermission.CREATE_TRACK, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, List<String> args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String trackName = args.get(0).toLowerCase();
        if (!DataConstraints.TRACK_NAME_TEST.test(trackName)) {
            Message.TRACK_INVALID_ENTRY.send(sender, trackName);
            return CommandResult.INVALID_ARGS;
        }
        if (plugin.getStorage().loadTrack(trackName).join().isPresent()) {
            Message.ALREADY_EXISTS.send(sender, trackName);
            return CommandResult.INVALID_ARGS;
        }
        try {
            plugin.getStorage().createAndLoadTrack(trackName, CreationCause.COMMAND).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            Message.CREATE_ERROR.send(sender, trackName);
            return CommandResult.FAILURE;
        }
        Message.CREATE_SUCCESS.send(sender, trackName);
        ExtendedLogEntry.build().actor(sender).actedName(trackName).type(LogEntry.Type.TRACK).action("create").build().submit(plugin, sender);
        return CommandResult.SUCCESS;
    }
}

