/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.caching.UserCachedData;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.Identifiable;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.primarygroup.ContextualHolder;
import me.lucko.luckperms.common.primarygroup.PrimaryGroupHolder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class User
extends PermissionHolder
implements Identifiable<UserIdentifier> {
    private final ApiUser apiDelegate = new ApiUser(this);
    private final UUID uuid;
    private @Nullable String name = null;
    private final PrimaryGroupHolder primaryGroup;
    private final UserCachedData cachedData;

    public User(UUID uuid, String name, LuckPermsPlugin plugin) {
        super(plugin);
        this.uuid = uuid;
        this.setName(name, false);
        this.primaryGroup = plugin.getConfiguration().get(ConfigKeys.PRIMARY_GROUP_CALCULATION).apply(this);
        this.cachedData = new UserCachedData(this);
        this.getPlugin().getEventFactory().handleUserCacheLoad(this, this.cachedData);
    }

    public User(UUID uuid, LuckPermsPlugin plugin) {
        this(uuid, null, plugin);
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        if (this.primaryGroup instanceof ContextualHolder) {
            ((ContextualHolder)this.primaryGroup).invalidateCache();
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public String getObjectName() {
        return this.uuid.toString();
    }

    @Override
    public UserIdentifier getId() {
        return UserIdentifier.of(this.uuid, this.name);
    }

    @Override
    public String getFormattedDisplayName() {
        return this.name != null ? this.name : this.uuid.toString();
    }

    @Override
    public String getPlainDisplayName() {
        return this.getFormattedDisplayName();
    }

    public ApiUser getApiDelegate() {
        return this.apiDelegate;
    }

    public UserCachedData getCachedData() {
        return this.cachedData;
    }

    public PrimaryGroupHolder getPrimaryGroup() {
        return this.primaryGroup;
    }

    public boolean setName(String name, boolean weak) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (weak && this.name != null) {
            if (name != null && this.name.equalsIgnoreCase(name)) {
                this.name = name;
            }
            return false;
        }
        if (name != null && (name.isEmpty() || name.equalsIgnoreCase("null"))) {
            name = null;
        }
        if (this.name == null != (name == null)) {
            this.name = name;
            return true;
        }
        if (this.name == null) {
            return false;
        }
        if (this.name.equalsIgnoreCase(name)) {
            this.name = name;
            return false;
        }
        this.name = name;
        return true;
    }

    @Override
    public HolderType getType() {
        return HolderType.USER;
    }

    @Override
    public boolean clearNodes() {
        boolean ret = super.clearNodes();
        if (!ret) {
            return false;
        }
        this.getPlugin().getUserManager().giveDefaultIfNeeded(this, false);
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "User(uuid=" + this.uuid + ")";
    }
}

