/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.node.factory.NodeBuilder;
import me.lucko.luckperms.common.utils.PatternCache;

public final class LegacyNodeFactory {
    private static final String[] CONTEXT_DELIMITERS = new String[]{"=", "(", ")", ","};
    private static final String[] GENERIC_DELIMITERS = new String[]{".", "/", "-", "$"};
    private static final Pattern LEGACY_SERVER_DELIM = PatternCache.compileDelimiterPattern("/", "\\");
    private static final Splitter LEGACY_SERVER_SPLITTER = Splitter.on((Pattern)LEGACY_SERVER_DELIM).limit(2);
    private static final Pattern LEGACY_WORLD_DELIM = PatternCache.compileDelimiterPattern("-", "\\");
    private static final Splitter LEGACY_WORLD_SPLITTER = Splitter.on((Pattern)LEGACY_WORLD_DELIM).limit(2);
    private static final Pattern LEGACY_EXPIRY_DELIM = PatternCache.compileDelimiterPattern("$", "\\");
    private static final Splitter LEGACY_EXPIRY_SPLITTER = Splitter.on((Pattern)LEGACY_EXPIRY_DELIM).limit(2);
    private static final Pattern LEGACY_CONTEXT_DELIM = PatternCache.compileDelimiterPattern(")", "\\");
    private static final Splitter CONTEXT_SPLITTER = Splitter.on((Pattern)LEGACY_CONTEXT_DELIM).limit(2);
    private static final Pattern LEGACY_CONTEXT_PAIR_DELIM = PatternCache.compileDelimiterPattern(",", "\\");
    private static final Pattern LEGACY_CONTEXT_PAIR_PART_DELIM = PatternCache.compileDelimiterPattern("=", "\\");
    private static final Splitter.MapSplitter LEGACY_CONTEXT_PART_SPLITTER = Splitter.on((Pattern)LEGACY_CONTEXT_PAIR_DELIM).withKeyValueSeparator(Splitter.on((Pattern)LEGACY_CONTEXT_PAIR_PART_DELIM));

    public static Node fromLegacyString(String s, boolean b) {
        if (b) {
            return LegacyNodeFactory.builderFromLegacyString(s, true).build();
        }
        return LegacyNodeFactory.builderFromLegacyString(s, false).build();
    }

    private static Node.Builder builderFromLegacyString(String s, boolean b) {
        if (LEGACY_SERVER_DELIM.matcher(s).find()) {
            Iterator parts = LEGACY_SERVER_SPLITTER.split((CharSequence)s).iterator();
            String parts0 = (String)parts.next();
            String parts1 = (String)parts.next();
            if (LEGACY_WORLD_DELIM.matcher(parts0).find()) {
                Iterator serverParts = LEGACY_WORLD_SPLITTER.split((CharSequence)parts0).iterator();
                String serverParts0 = (String)serverParts.next();
                String serverParts1 = (String)serverParts.next();
                if (LEGACY_EXPIRY_DELIM.matcher(parts1).find()) {
                    Iterator tempParts = LEGACY_EXPIRY_SPLITTER.split((CharSequence)parts1).iterator();
                    String tempParts0 = (String)tempParts.next();
                    String tempParts1 = (String)tempParts.next();
                    return new LegacyNodeBuilder(tempParts0).setServer(serverParts0).setWorld(serverParts1).setExpiry(Long.parseLong(tempParts1)).setValue(b);
                }
                return new LegacyNodeBuilder(parts1).setServer(serverParts0).setWorld(serverParts1).setValue(b);
            }
            if (LEGACY_EXPIRY_DELIM.matcher(parts1).find()) {
                Iterator tempParts = LEGACY_EXPIRY_SPLITTER.split((CharSequence)parts1).iterator();
                String tempParts0 = (String)tempParts.next();
                String tempParts1 = (String)tempParts.next();
                return new LegacyNodeBuilder(tempParts0).setServer(parts0).setExpiry(Long.parseLong(tempParts1)).setValue(b);
            }
            return new LegacyNodeBuilder(parts1).setServer(parts0).setValue(b);
        }
        if (LEGACY_EXPIRY_DELIM.matcher(s).find()) {
            Iterator tempParts = LEGACY_EXPIRY_SPLITTER.split((CharSequence)s).iterator();
            String tempParts0 = (String)tempParts.next();
            String tempParts1 = (String)tempParts.next();
            return new LegacyNodeBuilder(tempParts0).setExpiry(Long.parseLong(tempParts1)).setValue(b);
        }
        return new LegacyNodeBuilder(s).setValue(b);
    }

    static String escapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return LegacyNodeFactory.escapeDelimiters(s, GENERIC_DELIMITERS);
    }

    public static String unescapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        s = s.replace("{SEP}", ".");
        s = s.replace("{FSEP}", "/");
        s = s.replace("{DSEP}", "$");
        s = LegacyNodeFactory.unescapeDelimiters(s, GENERIC_DELIMITERS);
        return s;
    }

    private static String escapeDelimiters(String s, String ... delimiters) {
        if (s == null) {
            return null;
        }
        for (String d : delimiters) {
            s = s.replace(d, "\\" + d);
        }
        return s;
    }

    public static String unescapeDelimiters(String s, String ... delimiters) {
        if (s == null) {
            return null;
        }
        for (String d : delimiters) {
            s = s.replace("\\" + d, d);
        }
        return s;
    }

    private LegacyNodeFactory() {
    }

    private static final class LegacyNodeBuilder
    extends NodeBuilder {
        private static final Pattern NODE_CONTEXTS_PATTERN = Pattern.compile("\\(.+\\).*");

        LegacyNodeBuilder(String permission) {
            if (!NODE_CONTEXTS_PATTERN.matcher(permission).matches()) {
                this.permission = permission;
            } else {
                List contextParts = CONTEXT_SPLITTER.splitToList((CharSequence)permission.substring(1));
                this.permission = (String)contextParts.get(1);
                try {
                    Map map = LEGACY_CONTEXT_PART_SPLITTER.split((CharSequence)contextParts.get(0));
                    for (Map.Entry e : map.entrySet()) {
                        this.withExtraContext(LegacyNodeFactory.unescapeDelimiters((String)e.getKey(), CONTEXT_DELIMITERS), LegacyNodeFactory.unescapeDelimiters((String)e.getValue(), CONTEXT_DELIMITERS));
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

