/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.model;

import java.util.Optional;
import java.util.OptionalLong;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NodeHeldPermission<T extends Comparable<T>>
implements HeldPermission<T> {
    private final T holder;
    private final Node node;

    public static <T extends Comparable<T>> NodeHeldPermission<T> of(T holder, NodeDataContainer node) {
        return NodeHeldPermission.of(holder, node.toNode());
    }

    public static <T extends Comparable<T>> NodeHeldPermission<T> of(T holder, Node node) {
        return new NodeHeldPermission<T>(holder, node);
    }

    private NodeHeldPermission(T holder, Node node) {
        this.holder = holder;
        this.node = node;
    }

    @Override
    public @NonNull String getPermission() {
        return this.node.getPermission();
    }

    @Override
    public boolean getValue() {
        return this.node.getValue();
    }

    @Override
    public @NonNull Optional<String> getServer() {
        return this.node.getServer();
    }

    @Override
    public @NonNull Optional<String> getWorld() {
        return this.node.getWorld();
    }

    @Override
    public OptionalLong getExpiry() {
        return this.node.isTemporary() ? OptionalLong.of(this.node.getExpiryUnixTime()) : OptionalLong.empty();
    }

    @Override
    public ContextSet getContexts() {
        return this.node.getContexts();
    }

    @Override
    public @NonNull Node asNode() {
        return this.node;
    }

    @Override
    public @NonNull T getHolder() {
        return this.holder;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeHeldPermission)) {
            return false;
        }
        NodeHeldPermission other = (NodeHeldPermission)o;
        return this.getHolder().equals(other.getHolder()) && this.getNode().equals(other.getNode());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHolder().hashCode();
        result = result * 59 + this.getNode().hashCode();
        return result;
    }
}

