/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.processors;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.nodetype.types.RegexType;
import me.lucko.luckperms.common.node.model.NodeTypes;
import me.lucko.luckperms.common.processors.AbstractPermissionProcessor;
import me.lucko.luckperms.common.processors.PermissionProcessor;

public class RegexProcessor
extends AbstractPermissionProcessor
implements PermissionProcessor {
    private Map<Pattern, Boolean> regexPermissions = Collections.emptyMap();

    @Override
    public Tristate hasPermission(String permission) {
        for (Map.Entry<Pattern, Boolean> e : this.regexPermissions.entrySet()) {
            if (!e.getKey().matcher(permission).matches()) continue;
            return Tristate.fromBoolean(e.getValue());
        }
        return Tristate.UNDEFINED;
    }

    @Override
    public void refresh() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.sourceMap.entrySet()) {
            Pattern pattern;
            RegexType regexType = NodeTypes.parseRegexType((String)e.getKey());
            if (regexType == null || (pattern = (Pattern)regexType.getPattern().orElse(null)) == null) continue;
            builder.put((Object)pattern, e.getValue());
        }
        this.regexPermissions = builder.build();
    }
}

