/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.Function;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.classloader.IsolatedClassLoader;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.FlatfileConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.NonClosableConnection;

public class H2ConnectionFactory
extends FlatfileConnectionFactory {
    private final Driver driver;
    private NonClosableConnection connection;

    public H2ConnectionFactory(LuckPermsPlugin plugin, Path file) {
        super(file);
        Path data = file.getParent().resolve("luckperms.db.mv.db");
        if (Files.exists(data, new LinkOption[0])) {
            try {
                Files.move(data, this.getWriteFile(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IsolatedClassLoader classLoader = plugin.getDependencyManager().obtainClassLoaderWith(EnumSet.of(Dependency.H2_DRIVER));
        try {
            Class<?> driverClass = classLoader.loadClass("org.h2.Driver");
            Method loadMethod = driverClass.getMethod("load", new Class[0]);
            this.driver = (Driver)loadMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getImplementationName() {
        return "H2";
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection;
        if ((this.connection == null || this.connection.isClosed()) && (connection = this.driver.connect("jdbc:h2:" + this.file.toString(), new Properties())) != null) {
            this.connection = NonClosableConnection.wrap(connection);
        }
        if (this.connection == null) {
            throw new SQLException("Unable to get a connection.");
        }
        return this.connection;
    }

    @Override
    public void shutdown() throws Exception {
        if (this.connection != null) {
            this.connection.shutdown();
        }
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace("'", "");
    }

    @Override
    protected Path getWriteFile() {
        return this.file.getParent().resolve(this.file.getFileName().toString() + ".mv.db");
    }
}

