/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.tasks;

import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class ExpireTemporaryTask
implements Runnable {
    private final LuckPermsPlugin plugin;

    public ExpireTemporaryTask(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        boolean groupChanges = false;
        for (Group group : this.plugin.getGroupManager().getAll().values()) {
            if (ExpireTemporaryTask.shouldSkip(group) || !group.auditTemporaryPermissions()) continue;
            this.plugin.getStorage().saveGroup(group);
            groupChanges = true;
        }
        for (User user : this.plugin.getUserManager().getAll().values()) {
            if (ExpireTemporaryTask.shouldSkip(user) || !user.auditTemporaryPermissions()) continue;
            this.plugin.getStorage().saveUser(user);
        }
        if (groupChanges) {
            this.plugin.getGroupManager().invalidateAllGroupCaches();
            this.plugin.getUserManager().invalidateAllUserCaches();
        }
    }

    private static boolean shouldSkip(PermissionHolder holder) {
        if (!holder.getIoLock().tryLock()) {
            return true;
        }
        holder.getIoLock().unlock();
        return false;
    }
}

