/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.treeview.TreeNode;
import me.lucko.luckperms.common.utils.RepeatingTask;

public class PermissionRegistry
extends RepeatingTask {
    private static final Splitter DOT_SPLIT = Splitter.on((char)'.').omitEmptyStrings();
    private final TreeNode rootNode = new TreeNode();
    private final Queue<String> queue = new ConcurrentLinkedQueue<String>();

    public PermissionRegistry(SchedulerAdapter scheduler) {
        super(scheduler, 1L, TimeUnit.SECONDS);
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    protected void tick() {
        String e;
        while ((e = this.queue.poll()) != null) {
            this.insert(e);
        }
    }

    public void offer(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        this.queue.offer(permission);
    }

    public void insert(String permission) {
        try {
            this.doInsert(permission);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<String> rootAsList() {
        return this.rootNode.makeImmutableCopy().getNodeEndings().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public int getSize() {
        return this.rootNode.getDeepSize();
    }

    private void doInsert(String permission) {
        List parts = DOT_SPLIT.splitToList((CharSequence)permission);
        TreeNode current = this.rootNode;
        for (String part : parts) {
            if ((current = current.tryInsert(part)) != null) continue;
            return;
        }
    }
}

