/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import com.google.common.collect.Range;
import java.util.function.Predicate;

public final class Predicates {
    private static final Predicate FALSE = new Predicate(){

        public boolean test(Object o) {
            return false;
        }

        public Predicate and(Predicate other) {
            return this;
        }

        public Predicate or(Predicate other) {
            return other;
        }

        public Predicate negate() {
            return TRUE;
        }
    };
    private static final Predicate TRUE = new Predicate(){

        public boolean test(Object o) {
            return true;
        }

        public Predicate and(Predicate other) {
            return other;
        }

        public Predicate or(Predicate other) {
            return this;
        }

        public Predicate negate() {
            return FALSE;
        }
    };

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static Predicate<Integer> notInRange(int start, int end) {
        Range range = Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        return value -> !range.contains((Comparable)value);
    }

    public static Predicate<Integer> inRange(int start, int end) {
        Range range = Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        return arg_0 -> ((Range)range).contains(arg_0);
    }

    public static <T> Predicate<T> not(T t) {
        return obj -> !t.equals(obj);
    }

    public static <T> Predicate<T> is(T t) {
        return t::equals;
    }

    private Predicates() {
    }
}

