/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import java.util.UUID;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Uuids {
    public static final Predicate<String> PREDICATE = s -> Uuids.parse(s) != null;

    public static @Nullable UUID fromString(String s) {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static @Nullable UUID parse(String s) {
        UUID uuid = Uuids.fromString(s);
        if (uuid == null && s.length() == 32) {
            try {
                uuid = new UUID(Long.parseUnsignedLong(s.substring(0, 16), 16), Long.parseUnsignedLong(s.substring(16), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return uuid;
    }

    private Uuids() {
    }
}

