/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeCommandExecutor
extends CommandManager
implements CommandCallable {
    private static final Splitter TAB_COMPLETE_ARGUMENT_SPLITTER = Splitter.on((Pattern)COMMAND_SEPARATOR_PATTERN);
    private static final Splitter ARGUMENT_SPLITTER = Splitter.on((Pattern)COMMAND_SEPARATOR_PATTERN).omitEmptyStrings();
    private final LPSpongePlugin plugin;

    public SpongeCommandExecutor(LPSpongePlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public @NonNull CommandResult process(@NonNull CommandSource source, @NonNull String s) {
        Sender lpSender = this.plugin.getSenderFactory().wrap(source);
        List<String> arguments = this.processSelectors(source, CommandManager.stripQuotes(ARGUMENT_SPLITTER.splitToList((CharSequence)s)));
        this.onCommand(lpSender, "lp", arguments);
        return CommandResult.success();
    }

    public @NonNull List<String> getSuggestions(@NonNull CommandSource source, @NonNull String s, @Nullable Location<World> location) {
        Sender lpSender = this.plugin.getSenderFactory().wrap(source);
        List<String> arguments = this.processSelectors(source, CommandManager.stripQuotes(TAB_COMPLETE_ARGUMENT_SPLITTER.splitToList((CharSequence)s)));
        return this.onTabComplete(lpSender, arguments);
    }

    public boolean testPermission(@NonNull CommandSource source) {
        return true;
    }

    public @NonNull Optional<Text> getShortDescription(@NonNull CommandSource source) {
        return Optional.of(Text.of((String)"Manage permissions"));
    }

    public @NonNull Optional<Text> getHelp(@NonNull CommandSource source) {
        return Optional.of(Text.of((String)"Run /luckperms to view usage."));
    }

    public @NonNull Text getUsage(@NonNull CommandSource source) {
        return Text.of((String)"/luckperms");
    }

    private List<String> processSelectors(CommandSource source, List<String> args) {
        ListIterator<String> it = args.listIterator();
        while (it.hasNext()) {
            String element = it.next();
            if (!element.startsWith("@")) continue;
            try {
                Selector.parse((String)element).resolve(source).stream().filter(e -> e instanceof Player).map(e -> (Player)e).findFirst().ifPresent(ret -> it.set(ret.getUniqueId().toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return args;
    }
}

