/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.commands.OptionClear;
import me.lucko.luckperms.sponge.commands.OptionInfo;
import me.lucko.luckperms.sponge.commands.OptionSet;
import me.lucko.luckperms.sponge.commands.OptionUnset;
import me.lucko.luckperms.sponge.commands.ParentAdd;
import me.lucko.luckperms.sponge.commands.ParentClear;
import me.lucko.luckperms.sponge.commands.ParentInfo;
import me.lucko.luckperms.sponge.commands.ParentRemove;
import me.lucko.luckperms.sponge.commands.PermissionClear;
import me.lucko.luckperms.sponge.commands.PermissionInfo;
import me.lucko.luckperms.sponge.commands.PermissionSet;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SpongeMainCommand
extends Command<Void, LPSubjectData> {
    private final LPSpongePlugin plugin;
    private final Map<String, List<Command<LPSubjectData, ?>>> subCommands;

    public SpongeMainCommand(LPSpongePlugin plugin) {
        super(CommandSpec.SPONGE.localize(plugin.getLocaleManager()), "Sponge", null, Predicates.alwaysFalse());
        LocaleManager locale = plugin.getLocaleManager();
        this.subCommands = ImmutableMap.builder().put((Object)"permission", (Object)ImmutableList.builder().add((Object)new PermissionInfo(locale)).add((Object)new PermissionSet(locale)).add((Object)new PermissionClear(locale)).build()).put((Object)"parent", (Object)ImmutableList.builder().add((Object)new ParentInfo(locale)).add((Object)new ParentAdd(locale)).add((Object)new ParentRemove(locale)).add((Object)new ParentClear(locale)).build()).put((Object)"option", (Object)ImmutableList.builder().add((Object)new OptionInfo(locale)).add((Object)new OptionSet(locale)).add((Object)new OptionUnset(locale)).add((Object)new OptionClear(locale)).build()).build();
        this.plugin = plugin;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Void v, List<String> args, String label) {
        CommandResult result;
        String type;
        LuckPermsService service = this.plugin.getService();
        if (args.size() < 1) {
            MessageUtils.sendPluginMessage(sender, "&aCurrent Subject Collections:\n" + MessageUtils.toCommaSep(service.getLoadedCollections().keySet().stream().filter(s -> !s.equalsIgnoreCase("user") && !s.equalsIgnoreCase("group")).sorted().collect(Collectors.toList())));
            return CommandResult.SUCCESS;
        }
        String subjectCollection = args.get(0);
        if (subjectCollection.equalsIgnoreCase("user") || subjectCollection.equalsIgnoreCase("group")) {
            MessageUtils.sendPluginMessage(sender, "Please use the main LuckPerms commands to edit users and groups.");
            return CommandResult.STATE_ERROR;
        }
        if (service.getLoadedCollections().keySet().stream().map(String::toLowerCase).noneMatch(s -> s.equalsIgnoreCase(subjectCollection))) {
            MessageUtils.sendPluginMessage(sender, "Warning: SubjectCollection '&4" + subjectCollection + "&c' doesn't already exist. Creating it now.");
        }
        LPSubjectCollection collection = service.getCollection(subjectCollection);
        if (args.size() < 2) {
            List<String> subjects = collection.getLoadedSubjects().stream().map(LPSubject::getIdentifier).collect(Collectors.toList());
            if (subjects.size() > 50) {
                List extra = subjects.subList(50, subjects.size());
                int overflow = extra.size();
                extra.clear();
                MessageUtils.sendPluginMessage(sender, "&aCurrent Subjects:\n" + MessageUtils.toCommaSep(subjects) + "&b ... and &a" + overflow + " &bmore.");
            } else {
                MessageUtils.sendPluginMessage(sender, "&aCurrent Subjects:\n" + MessageUtils.toCommaSep(subjects));
            }
            return CommandResult.SUCCESS;
        }
        if (args.size() < 4) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.SUCCESS;
        }
        boolean persistent = true;
        if (args.get(2).toLowerCase().startsWith("-t")) {
            persistent = false;
            args.remove(2);
        }
        if (!((type = args.get(2).toLowerCase()).equals("permission") || type.equals("parent") || type.equals("option"))) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String cmd = args.get(3);
        Optional<Command> o = this.subCommands.get(type).stream().filter(s -> s.getName().equalsIgnoreCase(cmd)).findAny();
        if (!o.isPresent()) {
            this.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        Command sub = o.get();
        if (!sub.isAuthorized(sender)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        ArrayList<String> strippedArgs = new ArrayList<String>();
        if (args.size() > 4) {
            strippedArgs.addAll(args.subList(4, args.size()));
        }
        if (sub.getArgumentCheck().test(strippedArgs.size())) {
            sub.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String subjectId = args.get(1);
        if (!collection.hasRegistered(subjectId).join().booleanValue()) {
            MessageUtils.sendPluginMessage(sender, "Warning: Subject '&4" + subjectId + "&c' doesn't already exist. Creating it now.");
        }
        LPSubject subject = collection.loadSubject(subjectId).join();
        LPSubjectData subjectData = persistent ? subject.getSubjectData() : subject.getTransientSubjectData();
        try {
            result = sub.execute(plugin, sender, subjectData, strippedArgs, label);
        }
        catch (CommandException e) {
            result = CommandManager.handleException(e, sender, label, sub);
        }
        return result;
    }

    @Override
    public void sendUsage(Sender sender, String label) {
        MessageUtils.sendPluginMessage(sender, "&3> &a" + String.format(this.getUsage(), label));
    }

    @Override
    public void sendDetailedUsage(Sender sender, String label) {
        MessageUtils.sendPluginMessage(sender, "&b" + this.getName() + " Sub Commands: &7(" + String.format("/%s sponge <collection> <subject> [-transient]", label) + " ...)");
        for (String s : Arrays.asList("Permission", "Parent", "Option")) {
            List subs = this.subCommands.get(s.toLowerCase()).stream().filter(sub -> sub.isAuthorized(sender)).collect(Collectors.toList());
            if (subs.isEmpty()) continue;
            MessageUtils.sendPluginMessage(sender, "&3>>  &b" + s);
            for (Command sub2 : subs) {
                sub2.sendUsage(sender, label);
            }
        }
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.getSubCommands().stream().anyMatch(sc -> sc.isAuthorized(sender));
    }

    public List<Command<LPSubjectData, ?>> getSubCommands() {
        return (List)this.subCommands.values().stream().flatMap(Collection::stream).collect(ImmutableCollectors.toList());
    }

    @Override
    public @NonNull Optional<List<Command<LPSubjectData, ?>>> getChildren() {
        return Optional.of(this.getSubCommands());
    }
}

