/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql.h2;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLAbstractProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class H2Provider
extends SQLAbstractProvider
implements SQLProvider {
    private static H2Provider INSTANCE = null;
    private final Path databasePath;

    public static H2Provider getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new H2Provider(eagleFactions);
                return INSTANCE;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    private H2Provider(EagleFactions eagleFactions) throws SQLException {
        super(eagleFactions);
        this.databasePath = eagleFactions.getConfigDir().resolve("data/h2/" + this.getDatabaseName());
        Connection connection = this.getConnection();
        connection.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:h2:" + this.databasePath, super.getUsername(), super.getPassword());
    }

    @Override
    public String getProviderName() {
        return "h2";
    }
}

