/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class IngotFormerRecipes
extends ProcessorRecipeHandler {
    private static final List<String> CASTING_BLACKLIST = Arrays.asList("glass", "coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon", "marshmallow");

    public IngotFormerRecipes() {
        super("ingot_former", 0, 1, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addIngotFormingRecipes();
        this.addIngotFormingRecipe("hard_carbon", "HardCarbon");
        this.addIngotFormingRecipe("manganese_dioxide", "ManganeseDioxide");
        this.addRecipe(IngotFormerRecipes.fluidStack("bas", 666), "gemBoronArsenide", 2.0, 2.0);
        if (OreDictHelper.oreExists("ingotObsidian")) {
            this.addRecipe(IngotFormerRecipes.fluidStack("obsidian", 72), "ingotObsidian", 0.5, 2.0);
        } else {
            this.addRecipe(IngotFormerRecipes.fluidStack("obsidian", 288), "obsidian", 2.0, 2.0);
        }
        this.addRecipe(IngotFormerRecipes.fluidStack("redstone", 100), "ingotRedstone", 0.25, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("glowstone", 250), "ingotGlowstone", 0.25, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("coal", 100), "ingotGraphite", 0.5, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("prismarine", 144), "gemPrismarine", 1.0, 1.0);
        if (OreDictHelper.oreExists("ingotSilicon")) {
            this.addRecipe(IngotFormerRecipes.fluidStack("silicon", 144), "ingotSilicon", 1.0, 1.0);
        } else {
            this.addRecipe(IngotFormerRecipes.fluidStack("silicon", 144), "itemSilicon", 1.0, 1.0);
        }
        this.addIngotFormingRecipe("electrical_steel", "ElectricalSteel");
        this.addIngotFormingRecipe("energetic_alloy", "EnergeticAlloy");
        this.addIngotFormingRecipe("vibrant_alloy", "VibrantAlloy");
        this.addIngotFormingRecipe("redstone_alloy", "RedstoneAlloy");
        this.addIngotFormingRecipe("conductive_iron", "ConductiveIron");
        this.addIngotFormingRecipe("pulsating_iron", "PulsatingIron");
        this.addIngotFormingRecipe("dark_steel", "DarkSteel");
        this.addIngotFormingRecipe("soularium", "Soularium");
        this.addIngotFormingRecipe("end_steel", "EndSteel");
        this.addIngotFormingRecipe("construction_alloy", "ConstructionAlloy");
        this.addIngotFormingRecipe("crude_steel", "CrudeSteel");
        this.addIngotFormingRecipe("crystalline_alloy", "CrystallineAlloy");
        this.addIngotFormingRecipe("melodic_alloy", "MelodicAlloy");
        this.addIngotFormingRecipe("stellar_alloy", "StellarAlloy");
        this.addIngotFormingRecipe("crystalline_pink_slime", "CrystallinePinkSlime");
        this.addIngotFormingRecipe("energetic_silver", "EnergeticSilver");
        this.addIngotFormingRecipe("vivid_alloy", "VividAlloy");
        this.addRecipe(IngotFormerRecipes.fluidStack("brine", 15), "dustSalt", 0.25, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("cocoa_butter", 144), "ingotCocoaButter", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("unsweetened_chocolate", 144), "ingotUnsweetenedChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("dark_chocolate", 144), "ingotDarkChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("milk_chocolate", 144), "ingotChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("sugar", 144), Items.field_151102_aT, 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("gelatin", 144), NCItems.gelatin, 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("marshmallow", 144), "ingotMarshmallow", 0.5, 0.5);
        this.addIsotopeFormingRecipes("Thorium", 230);
        this.addIngotFormingRecipe("fuel_tbu", "Thorium232Base");
        this.addIsotopeFormingRecipes("Uranium", 233, 235, 238);
        this.addIsotopeFormingRecipes("Neptunium", 236, 237);
        this.addIsotopeFormingRecipes("Plutonium", 238, 239, 241, 242);
        this.addIsotopeFormingRecipes("Americium", 241, 242, 243);
        this.addIsotopeFormingRecipes("Curium", 243, 245, 246, 247);
        this.addIsotopeFormingRecipes("Berkelium", 247, 248);
        this.addIsotopeFormingRecipes("Californium", 249, 250, 251, 252);
        this.addRecipe(IngotFormerRecipes.fluidStack("depleted_fuel_tbu", 1024), "depletedFuelTBU", 7.111111111111111, 1.0);
        this.addFissionFuelFormingRecipes("uranium", "eu", 233, 235);
        this.addFissionFuelFormingRecipes("neptunium", "en", 236);
        this.addFissionFuelFormingRecipes("plutonium", "ep", 239, 241);
        this.addFissionFuelFormingRecipes("americium", "ea", 242);
        this.addFissionFuelFormingRecipes("curium", "ec", "m", 243, 245, 247);
        this.addFissionFuelFormingRecipes("berkelium", "eb", 248);
        this.addFissionFuelFormingRecipes("californium", "ec", "f", 249, 251);
    }

    public void addIngotFormingRecipe(String fluid, String metal) {
        this.addRecipe(IngotFormerRecipes.fluidStack(fluid.toLowerCase(), 144), "ingot" + metal, 1.0, 1.0);
    }

    public void addIngotFormingRecipe(String metal) {
        this.addIngotFormingRecipe(metal, metal);
    }

    public void addIsotopeFormingRecipes(String element, int ... types) {
        for (int type : types) {
            this.addIngotFormingRecipe(element.toLowerCase() + "_" + type, element + type + "Base");
        }
    }

    public void addFissionFuelFormingRecipes(String element, String suffix, String suffixExtra, int ... types) {
        for (int type : types) {
            this.addRecipe(IngotFormerRecipes.fluidStack("fuel_l" + suffix + suffixExtra + "_" + type, 1296), "fuelL" + suffix.toUpperCase() + suffixExtra + type, 9.0, 1.0);
            this.addRecipe(IngotFormerRecipes.fluidStack("fuel_h" + suffix + suffixExtra + "_" + type, 1296), "fuelH" + suffix.toUpperCase() + suffixExtra + type, 9.0, 1.0);
            this.addRecipe(IngotFormerRecipes.fluidStack("depleted_fuel_l" + suffix + suffixExtra + "_" + type, 1296), "depletedFuelL" + suffix.toUpperCase() + suffixExtra + type, 7.111111111111111, 1.0);
            this.addRecipe(IngotFormerRecipes.fluidStack("depleted_fuel_h" + suffix + suffixExtra + "_" + type, 1296), "depletedFuelH" + suffix.toUpperCase() + suffixExtra + type, 7.111111111111111, 1.0);
        }
    }

    public void addFissionFuelFormingRecipes(String element, String suffix, int ... types) {
        this.addFissionFuelFormingRecipes(element, suffix, "", types);
    }

    public void addIngotFormingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (CASTING_BLACKLIST.contains(fluidName)) continue;
            String materialName = StringHelper.capitalize(fluidName);
            String ingot = "ingot" + materialName;
            String gem = "gem" + materialName;
            if (OreDictHelper.oreExists(ingot)) {
                this.addRecipe(IngotFormerRecipes.fluidStack(fluidName, 144), ingot, 1.0, 1.0);
                continue;
            }
            if (!OreDictHelper.oreExists(gem)) continue;
            this.addRecipe(IngotFormerRecipes.fluidStack(fluidName, 666), gem, 1.0, 1.0);
        }
    }
}

