/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.radiation;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import nc.radiation.environment.RadiationEnvironmentHandler;
import nc.radiation.environment.RadiationEnvironmentInfo;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.passive.TilePassiveAbstract;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.FourPos;
import nc.util.MaterialHelper;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileRadiationScrubber
extends TilePassiveAbstract
implements ITileRadiationEnvironment,
SimpleComponent {
    private double scrubberFraction = 0.0;
    private double currentChunkLevel = 0.0;
    private double currentChunkBuffer = 0.0;
    public final ConcurrentMap<BlockPos, Integer> occlusionMap = new ConcurrentHashMap<BlockPos, Integer>();
    private int radCheckCount = 0;

    public TileRadiationScrubber() {
        super("radiation_scrubber", new OreIngredient("dustBorax", 1), -NCConfig.radiation_scrubber_borax_rate, -NCConfig.radiation_scrubber_power, NCConfig.machine_update_rate / 5);
        this.stackChange = new OreIngredient("dustBorax", MathHelper.func_76130_a((int)this.itemChange) * NCConfig.machine_update_rate / 5);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            for (int x = -TileRadiationScrubber.searchRadius(); x <= TileRadiationScrubber.searchRadius(); ++x) {
                for (int y = -TileRadiationScrubber.searchRadius(); y <= TileRadiationScrubber.searchRadius(); ++y) {
                    for (int z = -TileRadiationScrubber.searchRadius(); z <= TileRadiationScrubber.searchRadius(); ++z) {
                        RadiationEnvironmentHandler.addTile(this.getFourPos().add(x, y, z), this);
                    }
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tickRadCount();
            if (this.shouldRadCheck()) {
                this.checkRadiationEnvironmentInfo();
            }
        }
    }

    public double getRawScrubberRate() {
        if (!this.isActive) {
            return 0.0;
        }
        double rateMult = this.currentChunkBuffer + NCConfig.radiation_spread_rate * Math.max(0.0, this.currentChunkLevel - this.currentChunkBuffer);
        if (NCConfig.radiation_scrubber_alt) {
            IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
            if (chunkSource == null || chunkSource.getEffectiveScrubberCount() == 0.0) {
                return 0.0;
            }
            return -rateMult * this.scrubberFraction * chunkSource.getScrubbingFraction() / chunkSource.getEffectiveScrubberCount();
        }
        return -rateMult * this.scrubberFraction;
    }

    public void tickRadCount() {
        ++this.radCheckCount;
        this.radCheckCount %= NCConfig.machine_update_rate * 20;
    }

    public boolean shouldRadCheck() {
        return this.radCheckCount == 0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        RadiationEnvironmentHandler.removeTile(this);
    }

    @Override
    public void checkRadiationEnvironmentInfo() {
        double newScrubberFraction = TileRadiationScrubber.getMaxScrubberFraction();
        Iterator occlusionIterator = this.occlusionMap.entrySet().iterator();
        int occlusionCount = 0;
        double tileCount = 0.0;
        while (occlusionIterator.hasNext()) {
            Map.Entry occlusion = occlusionIterator.next();
            if (TileRadiationScrubber.isOcclusive(this.field_174879_c, this.field_145850_b, (BlockPos)occlusion.getKey())) {
                newScrubberFraction -= TileRadiationScrubber.getOcclusionPenalty() / this.field_174879_c.func_177951_i((Vec3i)occlusion.getKey());
                ++occlusionCount;
                tileCount += Math.max(1.0, Math.sqrt(((Integer)occlusion.getValue()).intValue()));
                continue;
            }
            occlusionIterator.remove();
        }
        this.scrubberFraction = occlusionCount == 0 ? TileRadiationScrubber.getMaxScrubberFraction() : Math.max(0.0, newScrubberFraction * (double)occlusionCount / tileCount);
    }

    @Override
    public void handleRadiationEnvironmentInfo(RadiationEnvironmentInfo info) {
        FourPos fourPos = this.getFourPos();
        FourPos infoPos = info.pos;
        if (fourPos.getDimension() == infoPos.getDimension() && !fourPos.equals(infoPos) && !info.tileMap.isEmpty()) {
            this.occlusionMap.put(infoPos.getBlockPos(), Math.max(1, info.tileMap.size()));
        }
    }

    @Override
    public double getRadiationContributionFraction() {
        return this.isActive ? -this.scrubberFraction : 0.0;
    }

    @Override
    public double getCurrentChunkRadiationLevel() {
        return this.currentChunkLevel;
    }

    @Override
    public void setCurrentChunkRadiationLevel(double level) {
        this.currentChunkLevel = level;
    }

    @Override
    public double getCurrentChunkRadiationBuffer() {
        return this.currentChunkBuffer;
    }

    @Override
    public void setCurrentChunkRadiationBuffer(double buffer) {
        this.currentChunkBuffer = buffer;
    }

    public static double getMaxScrubberFraction() {
        return NCConfig.radiation_scrubber_alt ? 1.0 : NCConfig.radiation_scrubber_fraction;
    }

    private static double getOcclusionPenalty() {
        return TileRadiationScrubber.getMaxScrubberFraction() / 52.0;
    }

    private static int searchRadius() {
        return NCConfig.radiation_scrubber_radius;
    }

    private static boolean isOcclusive(BlockPos pos, World world, BlockPos otherPos) {
        return pos.func_177951_i((Vec3i)otherPos) < (double)NCMath.square(TileRadiationScrubber.searchRadius()) && !MaterialHelper.isEmpty(world.func_180495_p(otherPos).func_185904_a());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TileRadiationScrubber)) {
            return false;
        }
        return this.getFourPos().equals(((TileRadiationScrubber)obj).getFourPos());
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("scrubberRate", this.scrubberFraction);
        nbt.func_74780_a("currentChunkLevel", this.currentChunkLevel);
        nbt.func_74780_a("currentChunkBuffer", this.currentChunkBuffer);
        int count = 0;
        for (Map.Entry occlusion : this.occlusionMap.entrySet()) {
            BlockPos pos = (BlockPos)occlusion.getKey();
            nbt.func_74783_a("occlusion" + count, new int[]{(Integer)occlusion.getValue(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            ++count;
        }
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.scrubberFraction = nbt.func_74769_h("scrubberRate");
        this.currentChunkLevel = nbt.func_74769_h("currentChunkLevel");
        this.currentChunkBuffer = nbt.func_74769_h("currentChunkBuffer");
        for (String key : nbt.func_150296_c()) {
            int[] data;
            if (!key.startsWith("occlusion") || (data = nbt.func_74759_k(key)).length < 4) continue;
            this.occlusionMap.put(new BlockPos(data[1], data[2], data[3]), data[0]);
        }
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_radiation_scrubber";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getRadiationRemovalRate(Context context, Arguments args) {
        return new Object[]{this.getRawScrubberRate()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{Math.abs(100.0 * this.getRadiationContributionFraction() / TileRadiationScrubber.getMaxScrubberFraction())};
    }
}

