/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands;

import com.gmail.trentech.pjp.events.TeleportEvent;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CMDBack
implements CommandExecutor {
    public CommandSpec cmdBack = CommandSpec.builder().description((Text)Text.of((String)"Send player to last place they were")).permission("pjp.cmd.back").executor((CommandExecutor)this).build();
    public static ConcurrentHashMap<Player, Location<World>> players = new ConcurrentHashMap();

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}));
        }
        Player player = (Player)src;
        if (players.get(player) == null) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "No position to teleport to"}));
        }
        Location spawnLocation = players.get(player);
        PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
        while (portalService.get(spawnLocation, Portal.PortalType.PORTAL).isPresent() || portalService.get(spawnLocation, Portal.PortalType.DOOR).isPresent()) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int x = random.nextInt(10) - 5 + spawnLocation.getBlockX();
            int z = random.nextInt(10) - 5 + spawnLocation.getBlockZ();
            Optional optionalLocation = Sponge.getGame().getTeleportHelper().getSafeLocation(((World)spawnLocation.getExtent()).getLocation(x, spawnLocation.getBlockY(), z));
            if (!optionalLocation.isPresent()) continue;
            spawnLocation = (Location)optionalLocation.get();
        }
        TeleportEvent.Local teleportEvent = new TeleportEvent.Local(player, (Location<World>)player.getLocation(), spawnLocation, 0.0, true, Optional.empty(), Cause.of((EventContext)EventContext.builder().add(EventContextKeys.PLAYER, (Object)player).build(), (Object)player));
        if (!Sponge.getEventManager().post((Event)teleportEvent)) {
            spawnLocation = teleportEvent.getDestination();
            player.setLocation(spawnLocation);
        }
        return CommandResult.success();
    }
}

