/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.data.mutable;

import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.immutable.ImmutableHomeData;
import com.gmail.trentech.pjp.portal.Portal;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractMappedData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.MapValue;

public class HomeData
extends AbstractMappedData<String, Portal, HomeData, ImmutableHomeData> {
    public HomeData(Map<String, Portal> value) {
        super(value, Keys.PORTALS);
    }

    public HomeData() {
        super(new HashMap(), Keys.PORTALS);
    }

    public MapValue<String, Portal> portals() {
        return Sponge.getRegistry().getValueFactory().createMapValue(Keys.PORTALS, this.getValue());
    }

    public Optional<Portal> get(String key) {
        if (this.getValue().containsKey(key)) {
            return Optional.of(this.getValue().get(key));
        }
        return Optional.empty();
    }

    public Set<String> getMapKeys() {
        return this.getValue().keySet();
    }

    public HomeData put(String key, Portal value) {
        this.getValue().put(key, value);
        return this;
    }

    public HomeData putAll(Map<? extends String, ? extends Portal> map) {
        this.getValue().putAll(map);
        return this;
    }

    public HomeData remove(String key) {
        this.getValue().remove(key);
        return this;
    }

    public Optional<HomeData> fill(DataHolder dataHolder, MergeFunction mergeFn) {
        HomeData homeData = (HomeData)((MergeFunction)Preconditions.checkNotNull((Object)mergeFn)).merge((ValueContainer)this.copy(), (ValueContainer)dataHolder.get(HomeData.class).orElse(this.copy()));
        return Optional.of(this.set(Keys.PORTALS, homeData.get(Keys.PORTALS).get()));
    }

    public Optional<HomeData> from(DataContainer container) {
        if (container.contains(Keys.PORTALS.getQuery())) {
            HashMap<String, Portal> homeList = new HashMap<String, Portal>();
            DataView homes = (DataView)container.getView(Keys.PORTALS.getQuery()).get();
            for (DataQuery home : homes.getKeys(false)) {
                Optional optionalLocal = homes.getSerializable(home, Portal.Local.class);
                if (optionalLocal.isPresent()) {
                    homeList.put(home.toString(), (Portal)optionalLocal.get());
                    continue;
                }
                homeList.put(home.toString(), (Portal)homes.getSerializable(home, Portal.Server.class).get());
            }
            return Optional.of(new HomeData(homeList));
        }
        return Optional.empty();
    }

    public HomeData copy() {
        return new HomeData(this.getValue());
    }

    public int getContentVersion() {
        return 0;
    }

    public ImmutableHomeData asImmutable() {
        return new ImmutableHomeData(this.getValue());
    }

    public DataContainer toContainer() {
        return super.toContainer().set(Keys.PORTALS, (Object)this.getValue());
    }

    public static class Builder
    extends AbstractDataBuilder<HomeData>
    implements DataManipulatorBuilder<HomeData, ImmutableHomeData> {
        public Builder() {
            super(HomeData.class, 0);
        }

        public Optional<HomeData> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(Keys.PORTALS.getQuery())) {
                HashMap<String, Portal> homeList = new HashMap<String, Portal>();
                DataView homes = (DataView)container.getView(Keys.PORTALS.getQuery()).get();
                for (DataQuery home : homes.getKeys(false)) {
                    Optional optionalLocal = homes.getSerializable(home, Portal.Local.class);
                    if (optionalLocal.isPresent()) {
                        homeList.put(home.toString(), (Portal)optionalLocal.get());
                        continue;
                    }
                    homeList.put(home.toString(), (Portal)homes.getSerializable(home, Portal.Server.class).get());
                }
                return Optional.of(new HomeData(homeList));
            }
            return Optional.empty();
        }

        public HomeData create() {
            return new HomeData(new HashMap<String, Portal>());
        }

        public Optional<HomeData> createFrom(DataHolder dataHolder) {
            return this.create().fill(dataHolder);
        }
    }
}

