/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.effects;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.ParticleColor;
import java.util.Optional;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.plugin.PluginContainer;

public enum Particles {
    PORTAL(new Particle("PORTAL", ParticleTypes.PORTAL, 10L)),
    FLAME(new Particle("FLAME", ParticleTypes.FLAME, 40L)),
    CLOUD(new Particle("CLOUD", ParticleTypes.CLOUD, 60L)),
    HEART(new Particle("HEART", ParticleTypes.HEART, 120L)),
    LARGE_SMOKE(new Particle("LARGE_SMOKE", ParticleTypes.LARGE_SMOKE, 60L)),
    ENCHANTING_GLYPHS(new Particle("ENCHANTING_GLYPHS", ParticleTypes.ENCHANTING_GLYPHS, 10L)),
    HAPPY_VILLAGER(new Particle("HAPPY_VILLAGER", ParticleTypes.HAPPY_VILLAGER, 50L)),
    WITCH_SPELL(new Particle("WITCH_SPELL", ParticleTypes.WITCH_SPELL, 15L)),
    NOTE(new Particle("NOTE", ParticleTypes.NOTE, 80L)),
    REDSTONE_DUST(new Particle("REDSTONE_DUST", ParticleTypes.REDSTONE_DUST, 15L)),
    SPELL(new Particle("SPELL", ParticleTypes.SPELL, 15L)),
    WATER_BUBBLE(new Particle("WATER_BUBBLE", ParticleTypes.WATER_BUBBLE, 5L)),
    MAGIC_CRITICAL_HIT(new Particle("MAGIC_CRITICAL_HIT", ParticleTypes.MAGIC_CRITICAL_HIT, 15L)),
    CRITICAL_HIT(new Particle("CRIT", ParticleTypes.CRITICAL_HIT, 15L)),
    SNOWBALL(new Particle("SNOWBALL", ParticleTypes.SNOWBALL, 15L)),
    SLIME(new Particle("SLIME", ParticleTypes.SLIME, 15L)),
    SNOW_SHOVEL(new Particle("SNOW_SHOVEL", ParticleTypes.SNOW_SHOVEL, 10L)),
    SUSPENDED_DEPTH(new Particle("SUSPENDED_DEPTH", ParticleTypes.SUSPENDED_DEPTH, 5L)),
    ANGRY_VILLAGER(new Particle("ANGRY_VILLAGER", ParticleTypes.ANGRY_VILLAGER, 40L)),
    WATER_SPLASH(new Particle("WATER_SPLASH", ParticleTypes.WATER_SPLASH, 7L)),
    WATER_WAKE(new Particle("WATER_WAKE", ParticleTypes.WATER_WAKE, 7L)),
    WATER_DROP(new Particle("WATER_DROP", ParticleTypes.WATER_DROP, 7L)),
    PORTAL2(new Particle("PORTAL2", ParticleTypes.PORTAL, 40L)),
    MOB_SPELL(new Particle("MOB_SPELL", ParticleTypes.MOB_SPELL, 50L)),
    AMBIENT_MOB_SPELL(new Particle("AMBIENT_MOB_SPELL", ParticleTypes.AMBIENT_MOB_SPELL, 50L)),
    NONE(new Particle("NONE", null, 0L)),
    BARRIER(new Particle("BARRIER", ParticleTypes.BARRIER, 2000L));

    private final Particle particle;

    private Particles(Particle particle) {
        this.particle = particle;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public static Optional<Particle> get(String name) {
        Particles[] particles;
        Optional<Particle> optional = Optional.empty();
        for (Particles particle : particles = Particles.values()) {
            if (!particle.particle.getName().equals(name)) continue;
            optional = Optional.of(particle.particle);
            break;
        }
        return optional;
    }

    public static Particle getDefaultEffect(String key) {
        CommentedConfigurationNode node = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "particles", key});
        if (node.isVirtual()) {
            Main.instance().getLog().warn("Can't find config node for " + key);
            return Particles.get("BARRIER").get();
        }
        String type = node.getNode(new Object[]{"type"}).getString().toUpperCase();
        Optional<Particle> optionalParticle = Particles.get(type);
        if (!optionalParticle.isPresent()) {
            Main.instance().getLog().warn("Can't find particle type for " + type);
            return Particles.get("BARRIER").get();
        }
        Particle particle = optionalParticle.get();
        return particle;
    }

    public static Optional<ParticleColor> getDefaultColor(String key, boolean colorable) {
        if (!colorable) {
            return Optional.empty();
        }
        CommentedConfigurationNode node = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "particles", key});
        if (node.isVirtual()) {
            Main.instance().getLog().warn("Can't find config node for " + key);
            return Optional.empty();
        }
        String color = node.getNode(new Object[]{"color"}).getString().toUpperCase();
        return ParticleColor.get(color);
    }
}

