/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.core.BungeeManager;
import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.core.SQLManager;
import com.gmail.trentech.pjc.core.TeleportManager;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.events.TeleportEvent;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.features.Command;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.portal.features.Properties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PortalService {
    private static ConcurrentHashMap<String, Portal> cache = new ConcurrentHashMap();

    public Optional<Portal> get(String name, Portal.PortalType type) {
        Portal portal;
        if (cache.containsKey(name) && (portal = cache.get(name)).getType().equals((Object)type)) {
            return Optional.of(cache.get(name));
        }
        return Optional.empty();
    }

    public Optional<Portal> get(Location<World> location, Portal.PortalType type) {
        if (type.equals((Object)Portal.PortalType.PORTAL)) {
            for (Map.Entry<String, Portal> entry : cache.entrySet()) {
                Properties properties;
                List<Location<World>> frame;
                Portal portal = entry.getValue();
                if (!portal.getType().equals((Object)type) || !((World)(frame = (properties = portal.getProperties().get()).getFrame()).get(0).getExtent()).equals(location.getExtent())) continue;
                for (Location<World> loc : frame) {
                    if (!loc.getBlockPosition().equals((Object)location.getBlockPosition())) continue;
                    return Optional.of(portal);
                }
                for (Location<World> loc : properties.getFill()) {
                    if (!loc.getBlockPosition().equals((Object)location.getBlockPosition())) continue;
                    return Optional.of(portal);
                }
            }
        }
        return this.get(((World)location.getExtent()).getName() + ":" + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ(), type);
    }

    public List<Portal> all(Portal.PortalType type) {
        ArrayList<Portal> list = new ArrayList<Portal>();
        for (Map.Entry<String, Portal> entry : cache.entrySet()) {
            Portal portal = entry.getValue();
            if (!portal.getType().equals((Object)type)) continue;
            list.add(portal);
        }
        return list;
    }

    public void init() {
        try {
            SQLManager sqlManager = SQLManager.get((PluginContainer)Main.getPlugin());
            Connection connection = sqlManager.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + sqlManager.getPrefix("PORTALS"));
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Portal portal;
                String name = result.getString("Name");
                try {
                    portal = Portal.deserialize(result.getString("Data"));
                    portal.setName(name);
                    cache.put(name, portal);
                    Optional<Properties> optionalProperties = portal.getProperties();
                    if (!optionalProperties.isPresent()) continue;
                    Properties properties = portal.getProperties().get();
                    properties.getParticle().createTask(name, properties.getFill(), properties.getParticleColor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    portal = new Portal.Local(null, null, 0.0, false);
                    portal.setName(name);
                    this.remove(portal);
                }
            }
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void create(Portal portal, String name) {
        portal.setName(name);
        try {
            SQLManager sqlManager = SQLManager.get((PluginContainer)Main.getPlugin());
            Connection connection = sqlManager.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("INSERT into " + sqlManager.getPrefix("PORTALS") + " (Name, Data) VALUES (?, ?)");
            statement.setString(1, portal.getName());
            statement.setString(2, Portal.serialize(portal));
            statement.executeUpdate();
            connection.close();
            cache.put(portal.getName(), portal);
            Optional<Properties> optionalProperties = portal.getProperties();
            if (optionalProperties.isPresent()) {
                Properties properties = optionalProperties.get();
                properties.getParticle().createTask(portal.getName(), properties.getFill(), properties.getParticleColor());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void create(Portal portal, Location<World> location) {
        portal.setName(((World)location.getExtent()).getName() + ":" + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ());
        this.create(portal, portal.getName());
        Particle particle = Particles.getDefaultEffect("creation");
        particle.spawnParticle(location, false, Particles.getDefaultColor("creation", particle.isColorable()));
    }

    public void update(Portal portal) {
        try {
            SQLManager sqlManager = SQLManager.get((PluginContainer)Main.getPlugin());
            Connection connection = sqlManager.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("UPDATE " + sqlManager.getPrefix("PORTALS") + " SET Data = ? WHERE Name = ?");
            statement.setString(1, Portal.serialize(portal));
            statement.setString(2, portal.getName());
            statement.executeUpdate();
            connection.close();
            cache.put(portal.getName(), portal);
            Optional<Properties> optionalProperties = portal.getProperties();
            if (optionalProperties.isPresent()) {
                Properties properties = optionalProperties.get();
                for (Task task : Sponge.getScheduler().getScheduledTasks()) {
                    if (!task.getName().equals(portal.getName())) continue;
                    task.cancel();
                    break;
                }
                properties.update(true);
                properties.getParticle().createTask(portal.getName(), properties.getFill(), properties.getParticleColor());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void remove(Portal portal) {
        try {
            Optional<Properties> optionalProperties;
            SQLManager sqlManager = SQLManager.get((PluginContainer)Main.getPlugin());
            Connection connection = sqlManager.getDataSource().getConnection();
            PreparedStatement statement = connection.prepareStatement("DELETE from " + sqlManager.getPrefix("PORTALS") + " WHERE Name = ?");
            statement.setString(1, portal.getName());
            statement.executeUpdate();
            connection.close();
            if (cache.contains(portal.getName())) {
                cache.remove(portal.getName());
            }
            if ((optionalProperties = portal.getProperties()).isPresent()) {
                Properties properties = optionalProperties.get();
                for (Task task : Sponge.getScheduler().getScheduledTasks()) {
                    if (!task.getName().equals(portal.getName())) continue;
                    task.cancel();
                    break;
                }
                properties.update(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean execute(Player player, Portal portal) {
        AtomicReference<Boolean> bool = new AtomicReference<Boolean>(false);
        Optional<String> optionalPermission = portal.getPermission();
        if (optionalPermission.isPresent() && !player.hasPermission(optionalPermission.get())) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Requires permission ", TextColors.YELLOW, optionalPermission.get()}));
            return false;
        }
        Optional<Command> optionalCommand = portal.getCommand();
        if (optionalCommand.isPresent()) {
            Command command = optionalCommand.get();
            if (command.getSrcType().equals((Object)Command.SourceType.CONSOLE)) {
                command.execute();
            } else {
                command.execute(player);
            }
        }
        if (portal instanceof Portal.Server) {
            Portal.Server server = (Portal.Server)portal;
            Consumer<String> consumer = serverName -> {
                TeleportEvent.Server teleportEvent = new TeleportEvent.Server(player, (String)serverName, server.getServer(), server.getPrice(), server.getPermission(), Cause.of((EventContext)EventContext.builder().add(EventContextKeys.PLAYER, (Object)player).build(), (Object)server));
                if (!Sponge.getEventManager().post((Event)teleportEvent)) {
                    BungeeManager.connect((Player)player, (String)teleportEvent.getDestination());
                    player.setLocation(player.getWorld().getSpawnLocation());
                    bool.set(true);
                }
            };
            BungeeManager.getServer(consumer, (Player)player);
        } else {
            Portal.Local local = (Portal.Local)portal;
            Optional<Coordinate> optionalCoodinate = local.getCoordinate();
            if (optionalCoodinate.isPresent()) {
                Optional<Location<World>> optionalSpawnLocation;
                String worldUuid;
                Optional optionalList;
                Map list;
                Coordinate coordinate = optionalCoodinate.get();
                if (coordinate.getPreset().equals((Object)Coordinate.Preset.BED)) {
                    list = new HashMap();
                    optionalList = player.get(Keys.BED_LOCATIONS);
                    if (optionalList.isPresent()) {
                        list = (Map)optionalList.get();
                    }
                    optionalSpawnLocation = list.containsKey(worldUuid = coordinate.getWorld().getUniqueId().toString()) ? ((Coordinate)list.get(worldUuid)).getLocation() : coordinate.getLocation();
                } else if (coordinate.getPreset().equals((Object)Coordinate.Preset.LAST_LOCATION)) {
                    list = new HashMap();
                    optionalList = player.get(Keys.LAST_LOCATIONS);
                    if (optionalList.isPresent()) {
                        list = (Map)optionalList.get();
                    }
                    optionalSpawnLocation = list.containsKey(worldUuid = coordinate.getWorld().getUniqueId().toString()) ? ((Coordinate)list.get(worldUuid)).getLocation() : coordinate.getLocation();
                } else {
                    optionalSpawnLocation = coordinate.getPreset().equals((Object)Coordinate.Preset.RANDOM) ? TeleportManager.getRandomLocation((World)coordinate.getWorld(), (int)ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "random_spawn_radius"}).getInt()) : coordinate.getLocation();
                }
                if (optionalSpawnLocation.isPresent()) {
                    Location<World> spawnLocation = optionalSpawnLocation.get();
                    TeleportEvent.Local teleportEvent = new TeleportEvent.Local(player, (Location<World>)player.getLocation(), spawnLocation, local.getPrice(), local.force(), local.getPermission(), Cause.of((EventContext)EventContext.builder().add(EventContextKeys.PLAYER, (Object)player).build(), (Object)local));
                    if (!Sponge.getEventManager().post((Event)teleportEvent)) {
                        spawnLocation = teleportEvent.getDestination();
                        Vector3d rotation = local.getRotation().toVector3d();
                        player.setLocationAndRotation(spawnLocation, rotation);
                        return true;
                    }
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not find location"}));
                }
            }
        }
        return bool.get();
    }
}

