/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;

public class DelayEntry
extends InfoEntry {
    int delay;

    public DelayEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "Delay Info";
    }

    @Override
    public boolean shouldRender() {
        return this.delay > 0;
    }

    @Override
    public void write(IWriteableBuffer buf) {
        buf.writeShort(this.getProcessor().getDelay());
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.delay = buf.readShort();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        helper.renderText(x - wid, y, width, "Delay: " + this.delay);
    }
}

