/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.prefab.blocks.GSBlockMulti;
import galaxyspace.core.registers.blocks.GSBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.entity.ILandable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAdvLandingPad
extends TileEntityMulti
implements IMultiBlock,
IFuelable,
IFuelDock {
    private IDockable dockedEntity;
    private boolean initialised;

    public TileEntityAdvLandingPad() {
        super(null);
    }

    public void func_73660_a() {
        if (!this.initialised) {
            if (!this.field_145850_b.field_72995_K) {
                this.onCreate(this.field_145850_b, this.func_174877_v());
            }
            this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
            this.initialised = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5));
            boolean docked = false;
            for (Object o : list) {
                IDockable fuelable;
                if (!(o instanceof IDockable) || ((Entity)o).field_70128_L || (fuelable = (IDockable)o).inFlight()) continue;
                docked = true;
                if (fuelable == this.dockedEntity || !fuelable.isDockValid((IFuelDock)this)) break;
                if (fuelable instanceof ILandable) {
                    ((ILandable)fuelable).landEntity(this.func_174877_v());
                    break;
                }
                fuelable.setPad((IFuelDock)this);
                break;
            }
            if (!docked) {
                this.dockedEntity = null;
            }
        }
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(placedPosition, positions);
        for (BlockPos pos : positions) {
            if (pos.func_177958_n() == placedPosition.func_177958_n() + 2 || pos.func_177958_n() == placedPosition.func_177958_n() - 2 || pos.func_177952_p() == placedPosition.func_177952_p() + 2 || pos.func_177952_p() == placedPosition.func_177952_p() - 2) {
                world.func_180501_a(pos, GSBlocks.FAKE_BLOCK.func_176223_P().func_177226_a(GSBlockMulti.MULTI_TYPE, (Comparable)((Object)GSBlockMulti.EnumBlockMultiType.ADVANCED_ROCKET_PAD_1)), 0);
            } else {
                world.func_180501_a(pos, GSBlocks.FAKE_BLOCK.func_176223_P().func_177226_a(GSBlockMulti.MULTI_TYPE, (Comparable)((Object)this.getGSMultiType())), 0);
            }
            world.func_175690_a(pos, (TileEntity)new TileEntityMulti(placedPosition));
        }
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public GSBlockMulti.EnumBlockMultiType getGSMultiType() {
        return GSBlockMulti.EnumBlockMultiType.ADVANCED_ROCKET_PAD;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int y = placedPosition.func_177956_o();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (x == 0 && z == 0) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GSBlocks.FAKE_BLOCK) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
        if (this.dockedEntity != null) {
            this.dockedEntity.onPadDestroyed();
            this.dockedEntity = null;
        }
    }

    public int addFuel(FluidStack liquid, boolean doFill) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addFuel(liquid, doFill);
        }
        return 0;
    }

    public FluidStack removeFuel(int amount) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeFuel(amount);
        }
        return null;
    }

    public HashSet<ILandingPadAttachable> getConnectedTiles() {
        HashSet<ILandingPadAttachable> connectedTiles = new HashSet<ILandingPadAttachable>();
        for (int x = this.func_174877_v().func_177958_n() - 2; x < this.func_174877_v().func_177958_n() + 3; ++x) {
            this.testConnectedTile(x, this.func_174877_v().func_177952_p() - 2, connectedTiles);
            this.testConnectedTile(x, this.func_174877_v().func_177952_p() + 2, connectedTiles);
        }
        for (int z = this.func_174877_v().func_177952_p() - 2; z < this.func_174877_v().func_177952_p() + 3; ++z) {
            this.testConnectedTile(this.func_174877_v().func_177958_n() - 2, z, connectedTiles);
            this.testConnectedTile(this.func_174877_v().func_177958_n() + 2, z, connectedTiles);
        }
        return connectedTiles;
    }

    private void testConnectedTile(int x, int z, HashSet<ILandingPadAttachable> connectedTiles) {
        BlockPos testPos = new BlockPos(x, this.func_174877_v().func_177956_o(), z);
        if (!this.field_145850_b.func_175668_a(testPos, false)) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(testPos);
        if (tile instanceof ILandingPadAttachable && ((ILandingPadAttachable)tile).canAttachToLandingPad((IBlockAccess)this.field_145850_b, this.func_174877_v())) {
            connectedTiles.add((ILandingPadAttachable)tile);
            if (GalacticraftCore.isPlanetsLoaded && tile instanceof TileEntityLaunchController) {
                ((TileEntityLaunchController)tile).setAttachedPad((IFuelDock)this);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 2), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 2), (double)(this.func_174877_v().func_177958_n() + 3), (double)this.func_174877_v().func_177956_o() + 0.4, (double)(this.func_174877_v().func_177952_p() + 3));
    }

    public boolean isBlockAttachable(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ILandingPadAttachable) {
            return ((ILandingPadAttachable)tile).canAttachToLandingPad(world, this.func_174877_v());
        }
        return false;
    }

    public IDockable getDockedEntity() {
        return this.dockedEntity;
    }

    public void dockEntity(IDockable entity) {
        this.dockedEntity = entity;
    }
}

