/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import me.modmuss50.rebornstorage.tiles.CraftingNode;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.RebornCore;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;

@Mod.EventBusSubscriber(modid="rebornstorage")
@RebornRegistry(modID="rebornstorage")
public class RebornStorageEventHandler {
    @ConfigRegistry(comment="Enable debug log output (warning can be spammy)")
    public static boolean debugLogging = false;
    private static Queue<Pair<ICraftingManager, RebuildReason>> rebuildQueue = new LinkedList<Pair<ICraftingManager, RebuildReason>>();

    public static void queue(ICraftingManager craftingManager, CraftingNode node, String reason) {
        if (node.getWorld().field_72995_K) {
            return;
        }
        for (ICraftingManager queued : rebuildQueue.stream().map(Pair::getLeft).collect(Collectors.toList())) {
            if (!queued.equals(craftingManager)) continue;
            return;
        }
        rebuildQueue.add((Pair<ICraftingManager, RebuildReason>)Pair.of((Object)craftingManager, (Object)new RebuildReason(node.getPos(), node.getWorld().field_73011_w.getDimension(), reason)));
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        Pair<ICraftingManager, RebuildReason> rebuildReasonPair;
        if (event.phase == TickEvent.Phase.END && event.world.field_73011_w.getDimension() == 0 && !event.world.field_72995_K && (rebuildReasonPair = rebuildQueue.poll()) != null) {
            if (debugLogging) {
                RebornCore.logHelper.info((Object)("Triggering cached crafting manager rebuild pos:" + ((RebuildReason)rebuildReasonPair.getRight()).toString()));
            }
            ((ICraftingManager)rebuildReasonPair.getLeft()).rebuild();
        }
    }

    private static class RebuildReason {
        BlockPos pos;
        int worldId;
        String reason;

        public RebuildReason(BlockPos pos, int worldId, String reason) {
            this.pos = pos;
            this.worldId = worldId;
            this.reason = reason;
        }

        public String toString() {
            return "RebuildReason{pos=" + this.pos + ", worldId=" + this.worldId + ", reason='" + this.reason + '\'' + '}';
        }
    }
}

