/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.RankUpper;

import br.net.fabiozumbi12.RankUpper.RUCommands;
import br.net.fabiozumbi12.RankUpper.RULang;
import br.net.fabiozumbi12.RankUpper.RUListener;
import br.net.fabiozumbi12.RankUpper.RULogger;
import br.net.fabiozumbi12.RankUpper.RUPerms;
import br.net.fabiozumbi12.RankUpper.config.PlayerStatsDB;
import br.net.fabiozumbi12.RankUpper.config.RUConfig;
import br.net.fabiozumbi12.RankUpper.hooks.PlaceholdersAPI;
import br.net.fabiozumbi12.RankUpper.hooks.RUAFK;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.sql.SqlService;

@Plugin(id="rankupper", name="RankUpper", version="4.0.5", authors={"FabioZumbi12"}, description="Auto rankup plugin based on various requirements", dependencies={@Dependency(id="placeholderapi", optional=true)})
public class RankUpper {
    @Inject
    public Game game;
    private EconomyService econ;
    private RUConfig cfgs;
    private RUPerms perms;
    @Inject
    private PluginContainer instance;
    private static RankUpper rankupper;
    private RULogger logger;
    private RULang lang;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private File defaultConfig;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    private PlayerStatsDB stats;
    private String dbPath;
    private DataSource dataSource;
    @Inject
    public GuiceObjectMapperFactory factory;

    public EconomyService getEconomy() {
        return this.econ;
    }

    public RUConfig getConfig() {
        return this.cfgs;
    }

    public RUPerms getPerms() {
        return this.perms;
    }

    public PluginContainer instance() {
        return this.instance;
    }

    public static RankUpper get() {
        return rankupper;
    }

    public RULogger getLogger() {
        return this.logger;
    }

    public RULang getLang() {
        return this.lang;
    }

    public File getDefConfig() {
        return this.defaultConfig;
    }

    public File getConfigDir() {
        return this.configDir.toFile();
    }

    public PlayerStatsDB getStats() {
        return this.stats;
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        try {
            String v;
            rankupper = this;
            this.logger = new RULogger();
            this.logger.info("Init config module...");
            this.cfgs = new RUConfig(this.factory);
            this.logger.info("Init stats module...");
            this.dbPath = String.format(this.cfgs.root().database.uri, RankUpper.get().getDefConfig().getParentFile().getAbsolutePath());
            this.dataSource = ((SqlService)Sponge.getServiceManager().provide(SqlService.class).get()).getDataSource(this.dbPath);
            this.stats = new PlayerStatsDB();
            this.logger.info("Init lang module...");
            this.lang = new RULang();
            this.logger.info("Init permissions module...");
            String string = v = this.game.getPlatform().getContainer(Platform.Component.API).getVersion().isPresent() ? (String)this.game.getPlatform().getContainer(Platform.Component.API).getVersion().get() : "8";
            if (v.startsWith("5") || v.startsWith("6")) {
                this.perms = (RUPerms)Class.forName("br.net.fabiozumbi12.RankUpper.RUPerms56").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (v.startsWith("7") || v.startsWith("8")) {
                this.perms = (RUPerms)Class.forName("br.net.fabiozumbi12.RankUpper.RUPerms78").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.logger.info("Init commands module...");
            RUCommands.init(this);
            this.game.getEventManager().registerListeners((Object)this, (Object)new RUListener());
            this.PlayerCounterHandler();
            this.AutoSaveHandler();
            this.registerNucleus();
            if (Sponge.getPluginManager().getPlugin("placeholderapi").isPresent()) {
                this.logger.info("Registering placeholders...");
                new PlaceholdersAPI(this);
            }
            this.logger.success("RankUpper enabled.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.severe("Error enabling RankUpper! Plugin Disabled.");
        }
    }

    private void registerNucleus() {
        if (this.cfgs.root().afk_support) {
            if (Sponge.getPluginManager().getPlugin("nucleus").isPresent()) {
                this.logger.info("Nucleus found. AFK support enabled.");
                RUAFK.init();
            } else {
                this.cfgs.root().afk_support = false;
                this.logger.info("Nucleus is not installed. AFK support has been disabled in your config.");
            }
        }
    }

    @Listener
    public void onStopServer(GameStoppingServerEvent e) {
        this.getStats().savePlayersStats();
        for (Task task : Sponge.getScheduler().getScheduledTasks((Object)this)) {
            task.cancel();
        }
        this.logger.severe("RankUpper disabled.");
    }

    public void reload() {
        for (Task task : Sponge.getScheduler().getScheduledTasks((Object)this)) {
            task.cancel();
        }
        try {
            this.getStats().savePlayersStats();
            this.getConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cfgs = new RUConfig(this.factory);
        this.lang = new RULang();
        try {
            this.dataSource = ((SqlService)Sponge.getServiceManager().provide(SqlService.class).get()).getDataSource(this.dbPath);
            this.stats = new PlayerStatsDB();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.PlayerCounterHandler();
        this.AutoSaveHandler();
        this.registerNucleus();
    }

    private void PlayerCounterHandler() {
        this.logger.info("Updating player times every " + this.cfgs.root().update_player_time_minutes + " minute(s)!");
        Sponge.getScheduler().createSyncExecutor((Object)this).scheduleWithFixedDelay(() -> {
            this.logger.debug("Updating played times to players!");
            this.getStats().AddPlayerTimes();
        }, (long)this.cfgs.root().update_player_time_minutes, (long)this.cfgs.root().update_player_time_minutes, TimeUnit.MINUTES);
    }

    @Listener
    public void onChangeServiceProvider(ChangeServiceProviderEvent event) {
        if (event.getService().equals(EconomyService.class)) {
            this.econ = (EconomyService)event.getNewProviderRegistration().getProvider();
        }
    }

    private void AutoSaveHandler() {
        this.logger.info("Saving database every " + this.cfgs.root().database_save_interval + " minute(s)!");
        Sponge.getScheduler().createSyncExecutor((Object)this).scheduleWithFixedDelay(() -> {
            this.logger.debug("Saving Database File!");
            this.getStats().savePlayersStats();
        }, (long)this.cfgs.root().database_save_interval, (long)this.cfgs.root().database_save_interval, TimeUnit.MINUTES);
    }
}

