/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.zpm;

import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.features.zpm.ZPMItem;
import gcewing.sg.features.zpm.ZpmConsole;
import gcewing.sg.interfaces.ISGEnergySource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public final class ZpmConsoleTE
extends BaseTileInventory
implements ISGEnergySource,
IEnergyStorage,
IInventory,
ITickable {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private EnergyStorage storage;
    private double maxEnergyBufferSize = 2.147483647E9;
    private double energyPerSGEnergyUnit = 80.0;
    private int maxInput = 0;
    private int maxOutput = 10000;
    private static final int firstZpmSlot = 0;
    public static final int numSlots = 1;
    public boolean loaded = false;
    private boolean debugOutput = false;
    private int maxExtract = 5000;

    public ZpmConsoleTE() {
    }

    public ZpmConsoleTE(double zpmEnergyPerSGEnergyUnit) {
        this.energyPerSGEnergyUnit = zpmEnergyPerSGEnergyUnit;
        this.storage = new EnergyStorage((int)this.maxEnergyBufferSize, this.maxInput, this.maxOutput);
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbttagcompound) {
        super.readContentsFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("capacity")) {
            int capacity = nbttagcompound.func_74762_e("capacity");
            int energy = nbttagcompound.func_74762_e("energy");
            this.storage = new EnergyStorage(capacity, this.maxInput, this.maxOutput, energy);
        }
        if (SGCraft.forceZPMCfgUpdate) {
            this.energyPerSGEnergyUnit = SGCraft.ZPMEnergyPerSGEnergyUnit;
            this.storage = new EnergyStorage((int)this.maxEnergyBufferSize);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbttagcompound) {
        super.writeContentsToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("capacity", this.storage.getMaxEnergyStored());
        nbttagcompound.func_74768_a("energy", this.storage.getEnergyStored());
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound result = new NBTTagCompound();
        this.func_189515_b(result);
        return result;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public IInventory getInventory() {
        return this;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(0);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack item = ItemStackHelper.func_188382_a(this.items, (int)0, (int)1);
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag.func_150297_b("AvailableEnergy", 99)) {
            tag.func_74780_a("AvailableEnergy", (double)this.storage.getEnergyStored());
            tag.func_74757_a("loadedIntoCart", false);
            this.storage = new EnergyStorage((int)this.maxEnergyBufferSize, this.maxInput, this.maxOutput);
        }
        this.loaded = false;
        if (this.field_145850_b != null) {
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmConsole.ZPM_LOADED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
        }
        this.func_70296_d();
        return ItemStackHelper.func_188383_a(this.items, (int)0);
    }

    @Override
    public ItemStack func_70298_a(int index, int quantity) {
        NBTTagCompound tag;
        ItemStack item = ItemStackHelper.func_188383_a(this.items, (int)0);
        IInventory inventory = this.getInventory();
        if (!item.func_190926_b()) {
            this.func_70296_d();
        }
        if ((tag = item.func_77978_p()) == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag != null && tag.func_150297_b("AvailableEnergy", 99)) {
            tag.func_74780_a("AvailableEnergy", (double)this.storage.getEnergyStored());
            tag.func_74757_a("loadedIntoCart", false);
            this.storage = new EnergyStorage((int)this.maxEnergyBufferSize, this.maxInput, this.maxOutput);
        }
        this.loaded = false;
        if (this.field_145850_b != null) {
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmConsole.ZPM_LOADED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
        }
        this.func_70296_d();
        return item;
    }

    @Override
    public void func_70299_a(int index, ItemStack item) {
        IBlockState other;
        this.items.set(0, (Object)item);
        if (this.field_145850_b != null && ZpmConsoleTE.isValidFuelItem(item) && !this.loaded) {
            if (this.getEnergyStored() == 0) {
                NBTTagCompound tag = item.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    item.func_77982_d(tag);
                }
                tag.func_74757_a("loadedIntoCart", true);
                if (!tag.func_150297_b("AvailableEnergy", 99)) {
                    tag.func_74780_a("AvailableEnergy", 2.147483647E9);
                    item.func_77982_d(tag);
                }
                this.storage = new EnergyStorage((int)this.maxEnergyBufferSize, this.maxInput, this.maxOutput, (int)tag.func_74769_h("AvailableEnergy"));
            }
            other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmConsole.ZPM_LOADED, (Comparable)Boolean.valueOf(ZpmConsoleTE.isValidFuelItem(item)));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.loaded = true;
        }
        if (this.field_145850_b != null) {
            other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmConsole.ZPM_LOADED, (Comparable)Boolean.valueOf(ZpmConsoleTE.isValidFuelItem(item)));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
        }
        this.func_70296_d();
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() == SGCraft.zpm && stack.func_190916_E() > 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack item) {
        return item.func_77973_b() instanceof ZPMItem;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        this.items.clear();
    }

    @Override
    public String func_70005_c_() {
        return "container.zpm_console";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString("ZPM Console");
    }

    public static ZpmConsoleTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ZpmConsoleTE ? (ZpmConsoleTE)te : null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.storage != null) {
            return (T)this.storage;
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tile;
                if (side == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side))) == null || tile instanceof ZpmConsoleTE || !tile.hasCapability(CapabilityEnergy.ENERGY, side) || ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)).getEnergyStored() >= ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)).getMaxEnergyStored()) continue;
                int max = ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)).receiveEnergy(this.extractEnergy(50000, true), true);
                ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)).receiveEnergy(this.extractEnergy(max, false), false);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int result = this.storage.receiveEnergy(maxReceive, simulate);
        this.markChanged();
        return result;
    }

    public int extractEnergy(int extract, boolean simulate) {
        if (extract > this.maxExtract) {
            extract = this.maxExtract;
        }
        int result = this.storage.extractEnergy(extract, simulate);
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
        return result;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.storage.canExtract();
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public double availableEnergy() {
        double available = (double)this.storage.getEnergyStored() / this.energyPerSGEnergyUnit;
        System.out.println("ZPM Console at: " + this.field_174879_c + " / " + this.field_145850_b + " Power debug: " + this.storage.getEnergyStored() + " / " + this.energyPerSGEnergyUnit + " == " + (int)available);
        return available;
    }

    @Override
    public double totalAvailableEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public double drawEnergyDouble(double request) {
        double available = (double)this.storage.getEnergyStored() / this.energyPerSGEnergyUnit;
        double supply = BaseUtils.min(request, available);
        this.storage.extractEnergy((int)(supply * this.energyPerSGEnergyUnit), false);
        this.markChanged();
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        if (this.debugOutput) {
            System.out.printf("SGCraft: ZPM Console: Supplying %s SGU of %s requested\n", supply, request);
        }
        return supply;
    }

    private boolean isTainted(ItemStack item) {
        boolean hasTaint = false;
        NBTTagList nbttaglist = item.func_77986_q();
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
            short k = nbttagcompound.func_74765_d("id");
            short l = nbttagcompound.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.func_185262_c((int)k);
            if (k != 51) continue;
            hasTaint = true;
        }
        return hasTaint;
    }
}

