/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.capabilities.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandlerInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006H\u0016J\u0016\u0010&\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000eJ\b\u0010'\u001a\u00020\u0012H\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR6\u0010\n\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnet/ndrei/teslacorelib/capabilities/inventory/SidedItemHandlerConfig;", "Lnet/ndrei/teslacorelib/capabilities/inventory/ISidedItemHandlerConfig;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagList;", "()V", "coloredInfo", "", "Lnet/ndrei/teslacorelib/inventory/ColoredItemHandlerInfo;", "getColoredInfo", "()Ljava/util/List;", "facesConfig", "Ljava/util/HashMap;", "Lnet/minecraft/item/EnumDyeColor;", "", "Lnet/minecraft/util/EnumFacing;", "Lkotlin/collections/HashMap;", "information", "addColoredInfo", "", "name", "", "color", "highlight", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "index", "", "info", "deserializeNBT", "nbt", "getSidesForColor", "isSideSet", "", "side", "removeColoredInfo", "serializeNBT", "setColorIndex", "setSidesForColor", "sides", "toggleSide", "updated", "tesla-core-lib"})
public class SidedItemHandlerConfig
implements ISidedItemHandlerConfig,
INBTSerializable<NBTTagList> {
    private final HashMap<EnumDyeColor, List<EnumFacing>> facesConfig;
    private List<ColoredItemHandlerInfo> information;

    @Override
    public boolean isSideSet(@NotNull EnumDyeColor color, @NotNull EnumFacing side) {
        List<EnumFacing> list;
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return this.facesConfig.containsKey(color) && (list = this.facesConfig.get(color)) != null && list.contains(side);
    }

    public final boolean toggleSide(@NotNull EnumDyeColor color, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (this.facesConfig.containsKey(color)) {
            List<EnumFacing> list = this.facesConfig.get(color);
            if (list != null && list.contains(side)) {
                list.remove(side);
            } else if (list != null) {
                list.add(side);
            } else {
                ArrayList arrayList = Lists.newArrayList((Object[])new EnumFacing[]{side});
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(side)");
                this.setSidesForColor(color, arrayList);
            }
        } else {
            ArrayList arrayList = Lists.newArrayList((Object[])new EnumFacing[]{side});
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList(side)");
            this.setSidesForColor(color, arrayList);
        }
        this.updated();
        return this.isSideSet(color, side);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ColoredItemHandlerInfo> getColoredInfo() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.toList((Iterable)this.information);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ColoredItemHandlerInfo it = (ColoredItemHandlerInfo)element$iv$iv;
            if (!(!it.getHighlight().isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)var3_3;
        return CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                ColoredItemHandlerInfo it = (ColoredItemHandlerInfo)a;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (ColoredItemHandlerInfo)b;
                Comparable comparable2 = comparable;
                Integer n = it.getIndex();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addColoredInfo(@NotNull String name, @NotNull EnumDyeColor color, @NotNull BoundingRectangle highlight) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)highlight, (String)"highlight");
        Iterable iterable = this.information;
        BoundingRectangle boundingRectangle = highlight;
        EnumDyeColor enumDyeColor = color;
        String string = name;
        SidedItemHandlerConfig sidedItemHandlerConfig = this;
        void var5_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ColoredItemHandlerInfo coloredItemHandlerInfo = (ColoredItemHandlerInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getIndex();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        Integer n = (Integer)CollectionsKt.max((Iterable)collection);
        sidedItemHandlerConfig.addColoredInfo(string, enumDyeColor, boundingRectangle, (n != null ? n : 0) + 10);
    }

    @Override
    public void addColoredInfo(@NotNull String name, @NotNull EnumDyeColor color, @NotNull BoundingRectangle highlight, int index) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)highlight, (String)"highlight");
        this.addColoredInfo(new ColoredItemHandlerInfo(name, color, highlight, index));
    }

    @Override
    public void addColoredInfo(@NotNull ColoredItemHandlerInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        this.information.add(info);
    }

    @Override
    @NotNull
    public List<EnumFacing> getSidesForColor(@NotNull EnumDyeColor color) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        if (this.facesConfig.containsKey(color)) {
            list = this.facesConfig.get(color);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void setSidesForColor(@NotNull EnumDyeColor color, @NotNull List<? extends EnumFacing> sides) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull(sides, (String)"sides");
        this.facesConfig.put(color, CollectionsKt.toMutableList((Collection)sides));
        this.updated();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NBTTagList serializeNBT() {
        Collection $receiver$iv22;
        NBTTagList list = new NBTTagList();
        Set<EnumDyeColor> set = this.facesConfig.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"this.facesConfig.keys");
        Collection collection = $receiver$iv22 = (Collection)set;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        EnumDyeColor[] enumDyeColorArray = thisCollection$iv.toArray(new EnumDyeColor[thisCollection$iv.size()]);
        if (enumDyeColorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        EnumDyeColor[] keys = enumDyeColorArray;
        int $receiver$iv22 = 0;
        int n = keys.length;
        while ($receiver$iv22 < n) {
            void k;
            NBTTagCompound nbt = new NBTTagCompound();
            EnumDyeColor enumDyeColor = keys[k];
            Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"keys[k]");
            nbt.func_74768_a("color", enumDyeColor.func_176765_a());
            NBTTagList sides = new NBTTagList();
            List<EnumFacing> list2 = this.facesConfig.get(keys[k]);
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            for (EnumFacing facing : list2) {
                sides.func_74742_a((NBTBase)new NBTTagInt(facing.func_176745_a()));
            }
            nbt.func_74782_a("sides", (NBTBase)sides);
            list.func_74742_a((NBTBase)nbt);
            ++k;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull NBTTagList nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        this.facesConfig.clear();
        int n = 0;
        int n2 = nbt.func_74745_c();
        while (n < n2) {
            void $receiver$iv;
            void i;
            NBTTagCompound item = nbt.func_150305_b((int)i);
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)item.func_74762_e("color"));
            ArrayList sides = Lists.newArrayList();
            NBTTagList list = item.func_150295_c("sides", 3);
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)list.func_74745_c());
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv;
                int n3 = item$iv = ((IntIterator)iterator).nextInt();
                Collection collection = sides;
                EnumFacing enumFacing = EnumFacing.func_82600_a((int)list.func_186858_c((int)it));
                collection.add(enumFacing);
            }
            this.facesConfig.put(color, sides);
            ++i;
        }
        this.updated();
    }

    protected void updated() {
    }

    @Override
    public void removeColoredInfo(@NotNull EnumDyeColor color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.information.removeIf(new Predicate<ColoredItemHandlerInfo>(color){
            final /* synthetic */ EnumDyeColor $color;

            public final boolean test(@NotNull ColoredItemHandlerInfo i) {
                Intrinsics.checkParameterIsNotNull((Object)i, (String)"i");
                return Intrinsics.areEqual((Object)i.getColor(), (Object)this.$color);
            }
            {
                this.$color = enumDyeColor;
            }
        });
        this.facesConfig.remove(color);
        this.updated();
    }

    public final void setColorIndex(@NotNull EnumDyeColor color, int index) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Iterable $receiver$iv = this.information;
        for (Object element$iv : $receiver$iv) {
            ColoredItemHandlerInfo it = (ColoredItemHandlerInfo)element$iv;
            if (!Intrinsics.areEqual((Object)it.getColor(), (Object)color)) continue;
            it.setIndex(index);
        }
    }

    public SidedItemHandlerConfig() {
        SidedItemHandlerConfig sidedItemHandlerConfig = this;
        Object object = new HashMap();
        sidedItemHandlerConfig.facesConfig = object;
        sidedItemHandlerConfig = this;
        sidedItemHandlerConfig.information = object = (List)new ArrayList();
    }
}

