/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class SortedCollection<E>
implements Collection<E> {
    private final ArrayList<E> list = new ArrayList();
    private boolean sorted = true;
    private final Comparator<? super E> comparator;

    public SortedCollection(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        if (!this.sorted) {
            this.list.sort(this.comparator);
            this.sorted = true;
        }
        return this.list.iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] array) {
        return this.list.toArray(array);
    }

    @Override
    public boolean add(E t) {
        if (this.list.add(t)) {
            this.sorted = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> collection) {
        if (this.list.addAll(collection)) {
            this.sorted = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public static <V> SortedCollection<V> create(Comparator<V> comparator) {
        return new SortedCollection<V>(comparator);
    }
}

