/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object3d;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import org.squiddev.plethora.utils.ByteBufUtils;

public class ObjectRoot3D
extends BaseObject
implements ObjectGroup.Group3D {
    private Vec3d origin;
    private int dimension;

    public ObjectRoot3D(int id, int parent) {
        super(id, parent, (byte)9);
    }

    public void recentre(World world, Vec3d origin) {
        int dimension = world.field_73011_w.getDimension();
        if (!origin.equals((Object)this.origin) || dimension != this.dimension) {
            this.origin = origin;
            this.dimension = dimension;
            this.setDirty();
        }
    }

    @Override
    public void readInitial(ByteBuf buf) {
        this.origin = ByteBufUtils.readVec3d(buf);
        this.dimension = buf.readInt();
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        ByteBufUtils.writeVec3d(buf, this.origin);
        buf.writeInt(this.dimension);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        IntSet children = canvas.getChildren(this.id());
        if (children == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderManager renderManager = minecraft.func_175598_ae();
        if (renderManager.field_78734_h == null || renderManager.field_78734_h.field_70170_p.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        double distance = renderManager.field_78733_k.field_151451_c * 16;
        if (this.origin.func_186679_c(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n) > distance * distance) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderManager.field_78730_l + this.origin.field_72450_a), (double)(-renderManager.field_78731_m + this.origin.field_72448_b), (double)(-renderManager.field_78728_n + this.origin.field_72449_c));
        canvas.drawChildren(children.iterator());
        GlStateManager.func_179121_F();
    }

    @PlethoraMethod(doc="-- Recenter this canvas relative to the current position.", worldThread=false)
    public static void recenter(@FromTarget ObjectRoot3D target, @FromContext(value={"origin"}) IWorldLocation location, @Optional Vec3d offset) {
        if (offset == null) {
            offset = Vec3d.field_186680_a;
        }
        target.recentre(location.getWorld(), location.getLoc().func_178787_e(offset));
    }
}

