/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.appliedenergistics;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.MachineSource;
import com.google.common.collect.ImmutableSet;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.PlethoraIntegration;

public class CraftingResult {
    private final Handler handler = new Handler();
    private final IGrid grid;
    private final IComputerAccess access;
    private final IActionHost source;
    private ICraftingJob job = null;
    private ICraftingLink link = null;

    public CraftingResult(@Nonnull IGrid grid, @Nullable IComputerAccess access, @Nonnull IActionHost source) {
        this.grid = grid;
        this.access = access;
        this.source = source;
    }

    public ICraftingCallback getCallback() {
        return this.handler;
    }

    public ICraftingRequester getRequester() {
        return this.handler;
    }

    @Nullable
    public ICraftingJob getJob() {
        return this.job;
    }

    @Nullable
    public ICraftingLink getLink() {
        return this.link;
    }

    public String getStatus() {
        if (this.job != null && this.job.isSimulation()) {
            return "missing";
        }
        if (this.link == null) {
            return "pending";
        }
        if (this.link.isCanceled()) {
            return "canceled";
        }
        if (this.link.isDone()) {
            return "finished";
        }
        return "unknown";
    }

    private void tryQueue(Object ... args) {
        if (this.access != null) {
            try {
                this.access.queueEvent("crafting_status", args);
            }
            catch (RuntimeException e) {
                PlethoraIntegration.LOG.error("Cannot queue crafting callback. Probably detached from the peripheral.", (Throwable)e);
            }
        }
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Check if this crafting task has finished.")
    public static boolean isFinished(@FromTarget CraftingResult result) {
        ICraftingJob job = result.getJob();
        if (job != null && job.isSimulation()) {
            return true;
        }
        ICraftingLink link = result.getLink();
        return link != null && link.isDone();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Check if this crafting task has been canceled.")
    public static boolean isCanceled(@FromTarget CraftingResult result) {
        ICraftingLink link = result.getLink();
        return link != null && link.isCanceled();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Get the status for this crafting task.")
    public static String status(@FromTarget CraftingResult result) {
        return result.getStatus();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Get the ID for this crafting task.")
    public static String getId(@FromTarget CraftingResult result) {
        ICraftingLink link = result.getLink();
        return link == null ? null : link.getCraftingID();
    }

    @PlethoraMethod(modId="appliedenergistics2", doc="-- Get the various items required for this task.")
    public static Map<Integer, ?> getComponents(IContext<CraftingResult> context) throws LuaException {
        CraftingResult result = (CraftingResult)context.getTarget();
        ICraftingJob job = result.getJob();
        if (job == null) {
            throw new LuaException("Task is still pending");
        }
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IItemList plan = channel.createList();
        job.populatePlan(plan);
        IStorageGrid storage = (IStorageGrid)result.grid.getCache(IStorageGrid.class);
        IMEMonitor monitor = storage.getInventory((IStorageChannel)channel);
        MachineSource source = new MachineSource(result.source);
        int i = 0;
        HashMap out = new HashMap(plan.size());
        for (IAEItemStack needed : plan) {
            HashMap<String, Object> component = new HashMap<String, Object>();
            IAEItemStack toExtract = needed.copy();
            toExtract.reset();
            toExtract.setStackSize(needed.getStackSize());
            long missing = needed.getStackSize();
            IAEItemStack extracted = (IAEItemStack)monitor.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (IActionSource)source);
            if (extracted != null) {
                missing -= extracted.getStackSize();
            }
            component.put("missing", missing);
            component.put("toCraft", needed.getStackSize());
            component.put("component", context.makePartialChild(needed).getMeta());
            out.put(++i, component);
        }
        return out;
    }

    private final class Handler
    implements ICraftingCallback,
    ICraftingRequester {
        private Handler() {
        }

        public void calculationComplete(ICraftingJob job) {
            CraftingResult.this.job = job;
            if (job.isSimulation()) {
                CraftingResult.this.tryQueue(new Object[]{null, "missing"});
            } else {
                ICraftingGrid crafting = (ICraftingGrid)CraftingResult.this.grid.getCache(ICraftingGrid.class);
                CraftingResult.this.link = crafting.submitJob(job, (ICraftingRequester)this, null, false, (IActionSource)new MachineSource(CraftingResult.this.source));
            }
        }

        public ImmutableSet<ICraftingLink> getRequestedJobs() {
            return CraftingResult.this.link == null ? ImmutableSet.of() : ImmutableSet.of((Object)CraftingResult.this.link);
        }

        public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack stack, Actionable actionable) {
            return stack;
        }

        public void jobStateChange(ICraftingLink link) {
            CraftingResult.this.tryQueue(new Object[]{link.getCraftingID(), CraftingResult.this.getStatus()});
        }

        public IGridNode getActionableNode() {
            return CraftingResult.this.source.getActionableNode();
        }
    }
}

