/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.xnet;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.SidedConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.squiddev.plethora.integration.xnet.NetworkChannelType;
import org.squiddev.plethora.integration.xnet.NetworkConnectorSettings;

class NetworkChannelSettings
implements IChannelSettings,
IWiredElement {
    private boolean cleanCache = true;
    private final Map<SidedConsumer, ConnectorNode> nodes = new HashMap<SidedConsumer, ConnectorNode>();
    private int refreshCooldown;
    private final IWiredNode channelNode = ComputerCraftAPI.createWiredNodeForElement((IWiredElement)this);
    private World controllerWorld;
    private BlockPos controllerBlockPos = null;
    private Vec3d controllerPos = Vec3d.field_186680_a;

    NetworkChannelSettings() {
    }

    public void tick(int channel, IControllerContext context) {
        boolean refresh;
        this.refreshCooldown = (this.refreshCooldown + 1) % 20;
        boolean bl = refresh = this.refreshCooldown == 0 || this.cleanCache;
        if (this.cleanCache) {
            this.cleanCache = false;
            Map connectors = context.getConnectors(channel);
            Iterator<SidedConsumer> it = this.nodes.keySet().iterator();
            while (it.hasNext()) {
                SidedConsumer consumer = it.next();
                if (connectors.containsKey(consumer)) continue;
                this.nodes.get(consumer).remove();
                it.remove();
            }
            for (Map.Entry entry : connectors.entrySet()) {
                SidedConsumer consumer = (SidedConsumer)entry.getKey();
                ConnectorNode existing = this.nodes.get(consumer);
                if (existing != null && existing.side == consumer.getSide()) continue;
                if (existing != null) {
                    existing.remove();
                }
                this.nodes.put(consumer, new ConnectorNode(consumer.getConsumerId(), consumer.getSide(), (NetworkConnectorSettings)((Object)entry.getValue()), this.channelNode));
            }
        }
        this.controllerWorld = context.getControllerWorld();
        if (context instanceof TileEntity) {
            this.updatePosition(((TileEntity)context).func_174877_v());
        } else if (refresh) {
            for (SidedConsumer consumer : this.nodes.keySet()) {
                BlockPos pos = context.findConsumerPosition(consumer.getConsumerId());
                if (pos == null) continue;
                this.updatePosition(pos);
                break;
            }
        }
        for (ConnectorNode node : this.nodes.values()) {
            node.tick(context, refresh);
        }
    }

    private void updatePosition(BlockPos pos) {
        if (!Objects.equals(this.controllerBlockPos, pos)) {
            this.controllerBlockPos = pos;
            this.controllerPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
    }

    public void writeToNBT(NBTTagCompound tag) {
    }

    public void cleanCache() {
        this.cleanCache = true;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return NetworkChannelType.CHANNEL_ICON;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }

    @Nonnull
    public IWiredNode getNode() {
        return this.channelNode;
    }

    @Nonnull
    public World getWorld() {
        return this.controllerWorld;
    }

    @Nonnull
    public Vec3d getPosition() {
        return this.controllerPos;
    }

    @Nonnull
    public String getSenderID() {
        return "xnet";
    }

    private static final class ConnectorNode {
        private final ConsumerId id;
        private final EnumFacing side;
        private final NetworkConnectorSettings settings;
        private final IWiredNode rootNode;
        private TileEntity tile;
        private IWiredNode node;

        private ConnectorNode(ConsumerId id, EnumFacing side, NetworkConnectorSettings settings, IWiredNode rootNode) {
            this.id = id;
            this.side = side;
            this.settings = settings;
            this.rootNode = rootNode;
        }

        void remove() {
            IWiredNode node = this.node;
            this.tile = null;
            if (node != null) {
                node.disconnectFrom(this.rootNode);
                this.node = null;
            }
        }

        void tick(IControllerContext context, boolean refresh) {
            IWiredNode newNode;
            if (this.node != null && (this.tile != null && this.tile.func_145837_r() || !context.matchColor(this.settings.getColorsMask()))) {
                this.remove();
            }
            if (!refresh) {
                return;
            }
            BlockPos pos = context.findConsumerPosition(this.id);
            if (this.tile == null) {
                this.tile = pos != null ? context.getControllerWorld().func_175625_s(pos.func_177972_a(this.side)) : null;
            }
            IWiredElement element = this.tile != null && this.tile.hasCapability(NetworkChannelType.Capabilities.WIRED_ELEMENT, this.settings.getFacing()) ? (IWiredElement)this.tile.getCapability(NetworkChannelType.Capabilities.WIRED_ELEMENT, this.settings.getFacing()) : null;
            IWiredNode iWiredNode = newNode = element == null ? null : element.getNode();
            if (newNode != this.node) {
                if (this.node != null) {
                    this.node.disconnectFrom(this.rootNode);
                }
                this.node = newNode;
                if (newNode != null) {
                    newNode.connectTo(this.rootNode);
                }
            }
        }
    }
}

