# Dynamic Shops
##### Modded Minecraft Economies are pretty hard to manage, especially as players reach the endgame and begin to churn out massive amounts of items to sell, rapidly inflating the value of money. Dynamic Shops is an attempt to help manage inflation as well as provide opportunities for unique ideas on your server. Uses an intuitive system for setting up shops. The graph that most of the shops use to determine price based on items bought/sold can be found at [https://tinyurl.com/logisticshop]. You can play with it to find the correct values for your own shop.

Tested with the current reccomended 1.12.2 versions of spongeforge, totaleconomy, and forge as of the 11-18-19 (spongeforge-1.12.2-2838-7.1.7.jar, TotalEconomy-1.8.1.jar, and forge-1.12.2-14.23.5.2847-universal.jar)

### PERMISSIONS:
| Permission                                             | Description                                                                                                                                                                                        |
|------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| dynamicshops.admin           | Grants the ability to create, delete, and set the price of all shops. This command should only be given to admins and can be used to run arbitrary commands from the console using commandshops!   |
| dynamicshops.buy.(shopName)  | Grants the ability to buy from all shops named (shopName) that are able to sell items. It is suggested you give all players dynamicshops.buy.* and negate permissions for certain shops if needed. |
| dynamicshops.sell.(shopName) | Grants the ability to sell to all shops named (shopName) that are able to buy items. It is suggested you give all players dynamicshops.sell.* and negate permissions for certain shops if needed.  |
### COMMANDS:

**Note! All of these commands will make you right click the sign that you want to create/adjust/reset! As a result, they must be run by the player rather than console.**

| Command                                                                               | Description/Example                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
|---------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| /dynamicshop                                                                          | Main command for the plugin. All commands are children of /dynamicshop                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| /ds                                                                                   | A shorthand version of the above command, provided for your covenience.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| /dynamicshop createShop (shopName) (minPrice) (maxPrice) (priceChangeRate) (optional) | This command creates a dynamic shop that buys/sells the item stack in your hand. For example, if you do /ds createShop getyourglowstone 1 2 0.05, while holding 32 glowstone, it will buy and sell 32 glowstone for a minimum of 1 currency and maximum of 2 currency, starting at 1.5 currency. It also preserves item metadata. priceChangeRate does not directly change the price, but determines the slope of a logistic curve. Use the graph at [https://tinyurl.com/dynamicshop1] to explore how modifying minPrice, maxPrice, and priceChangeRate will change the price. It is reccomended that priceChangeRate is below 0.05 for best results. By default, the initial price of a shop will the average of its minimum and maximum prices. However, if (optional) is a number, then that number will be the inital price. (optional) can also be buyOnly or sellOnly. If the shop is buyOnly, the initial price is set to 1 rounding unit (1 cent for dollar economies) above minPrice and players can only left click the shop to buy. Vice versa for sellOnly. If a shop can both buy and sell, the price for buying and selling will be slightly different but averaged to initialPrice in order to prevent infinite money exploits |
|                                                                                       | ex) Running /dynamicshop createShop GlowstoneEmporium 1 10 0.05 while holding a glowstone in your hand will make a shop named GlowstoneEmporium that players can buy/sell a glowstone from/to for 6.5 currency initially, but the price will increase as players buy from it and decrease as players sell to it.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|                                                                                       | ex) Running /dynamicshop createShop GiveMeGlowstoneee 1 10 0.05 sellOnly while holding a glowstone in your hand will make a shop named GiveMeGlowstoneee that players can sell a glowstone to for 10 currency initially, but the sell price will eventually decrease to 1 currency                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| /dynamicshop createStaticShop (shopName) (price) (optional)                           | This command works similarly to createShop. However, the price of the shop does not change. (optional) can only be used to reference buyOnly and sellOnly.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
|                                                                                       | ex) Running /dynamicshop createStaticShop unchangingGlowstone 6 while holding 8 glowstone in your hand will make a shop that always buys/sells 8 glowstone for 6 currency.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| /dynamicshop createCommandShop (shopName) (initial) (max) (priceChangeRate) (command) | This command creates a dynamic command shop. It is similar to createShop but it is buyOnly and runs the specified command from console whenever its bought from, rather than giving an item. Use @p wherever you want to specify the buyer's name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|                                                                                       | ex) /dynamicshop createCommandShop healmeplz 1 10 0.05 heal @p will create a shop named healmeplz that costs 1 currency initially but will eventually go up to 10 currency. When bought, it runs the command heal (buyer) from console.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| /dynamicshop setPrice (price)                                                         | This command allows an admin to set the price of a shop manually. It will not allow you to set the price less than the minimum price of a shop or the maximum price of a shop. (or any price > 0 for a static shop) Note that for buy/sell shops, setPrice will set it so that the buy and sell prices are close to, but not exactly the price you select in order to prevent glitches.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| /dynamicshop resetPrice                                                               | This command allows an admin to set the price of a shop back to its defaults. This is avg(maxPrice,minPrice) for a normal shop, almost minPrice for a sellOnly shop, and almost maxPrice for a buyOnly shop.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |

### IDEAS:

- Creating adminshops players can buy/sell to which react to oversupply or high demand by adjusting pricing accordingly. 

- Creating command shops that run a command to, for example, call down a supply drop in the world. As more players call down supply drops, the shop becomes more expensive.

### NOTE:

The plugin stores its information (a list of shops and their properties) to the file shops_db in the plugin's configuration folder. While it's generally not recommended, you can modify this database manually using a text editor (please back it up first!). The plugin is reload compatible and will reload the shops from the database file on reload. The only use I can see for directly modifying the database is to modify a commandshop to include a command with color codes, since minecraft doesn't allow you to write those.

### TODO:

- (Currently being worked on) Bulk buying and selling functionality for itemshops

- Add ability to use non-default currency ad modify antiSpam and save rates (currently you can only buy/sell from/to a shop 4 times a second. The database is saved every time a shop is created or deleted, as well as when a shop is bought or sold from. However, to prevent IO lag from spamming shops, it will not save on buy/sell if it already has done so within 5 seconds.

- Add a configurable way to make it so if a shop costs $1, selling to it only gives you $0.90 and buying costs $1.10 or something.

- Add shops that mirror an exponential growth function. 

- A sister plugin that integrates dynamic economy as a command that allows for item buying and selling per player rather than the entire server.

- your suggestion here. Let me know of ideas you may have on the issue tracker or though DM!