/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.effect.potion.PotionEffectType;

public class RegionAddEffectExecutor
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     */
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("effect") && args.hasAny("level")) {
            PotionEffectType effect = (PotionEffectType)args.getOne("effect").get();
            int level = (Integer)args.getOne("level").get();
            if (level < 0) {
                MessageUtils.sendErrorMessage(src, RegionText.TEXT_WRONG_EFFECT_LEVEL.getValue());
                return CommandResult.empty();
            }
            if (!RegionUtils.hasPendingRegion(src)) {
                MessageUtils.sendErrorMessage(src, RegionText.NO_PENDING_REGION.getValue());
                return CommandResult.empty();
            }
            Region pendingRegion = RegionUtils.getPendingRegion(src);
            if (pendingRegion.isLocal()) {
                LocalRegion region = (LocalRegion)pendingRegion;
                region.addEffect(effect, level);
                MessageUtils.sendSuccessMessage(src, RegionText.TEXT_EFFECT_ADDED.getValue());
                return CommandResult.empty();
            }
            MessageUtils.sendErrorMessage(src, RegionText.REGION_LOCAL_ONLY.getValue());
            return CommandResult.empty();
        }
        MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg add <role> <player> (region)";
    }
}

