/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.flowpowered.math.vector.Vector3d;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagDestroyListener {
    @Listener
    public void onEntityDestroyed(InteractEntityEvent.Primary event, @First Player player) {
        Entity targetEntity = event.getTargetEntity();
        EntityType type = targetEntity.getType();
        if ((FlagUtils.isBlockEntity(type) || targetEntity instanceof TileEntity) && this.handleEvent((Cancellable)event, (Location<World>)targetEntity.getLocation(), player)) {
            player.getWorld().spawnEntity(targetEntity);
        }
    }

    @Listener
    public void onBucketFill(InteractItemEvent.Secondary.MainHand event, @First Player player) {
        this.handleBucketFill((InteractItemEvent.Secondary)event, player);
    }

    @Listener
    public void onBucketFill(InteractItemEvent.Secondary.OffHand event, @First Player player) {
        this.handleBucketFill((InteractItemEvent.Secondary)event, player);
    }

    @Listener
    public void onBucketFill(InteractBlockEvent.Secondary event, @First Player player) {
        ItemType item;
        BlockType block = event.getTargetBlock().getState().getType();
        if ((block.equals(BlockTypes.WATER) || block.equals(BlockTypes.FLOWING_WATER) || block.equals(BlockTypes.LAVA) || block.equals(BlockTypes.FLOWING_LAVA)) && player.getItemInHand(event.getHandType()).isPresent() && ((item = ((ItemStack)player.getItemInHand(event.getHandType()).get()).getType()).equals(ItemTypes.BUCKET) || item.equals(ItemTypes.WATER_BUCKET) || item.equals(ItemTypes.LAVA_BUCKET))) {
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        }
    }

    private void handleBucketFill(InteractItemEvent.Secondary event, Player player) {
        BlockType block;
        ItemType item = event.getItemStack().getType();
        if ((item.equals(ItemTypes.BUCKET) || item.equals(ItemTypes.WATER_BUCKET) || item.equals(ItemTypes.LAVA_BUCKET)) && event.getInteractionPoint().isPresent() && ((block = player.getWorld().getBlock(((Vector3d)event.getInteractionPoint().get()).toInt()).getType()).equals(BlockTypes.WATER) || block.equals(BlockTypes.FLOWING_WATER) || block.equals(BlockTypes.LAVA) || block.equals(BlockTypes.FLOWING_LAVA))) {
            this.handleEvent((Cancellable)event, (Location<World>)player.getLocation(), player);
        }
    }

    @Listener
    public void onEntityCollide(CollideEntityEvent.Impact event, @First Player player) {
        Entity targetEntity;
        EntityType type;
        if (!event.getEntities().isEmpty() && FlagUtils.isBlockEntity(type = (targetEntity = (Entity)event.getEntities().get(0)).getType())) {
            this.handleEvent((Cancellable)event, (Location<World>)targetEntity.getLocation(), player);
        }
    }

    @Listener
    public void onBlockDestroyedByPlayer(ChangeBlockEvent.Break event, @First Player player) {
        if (!event.getTransactions().isEmpty()) {
            BlockSnapshot block = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getOriginal();
            BlockType type = block.getState().getType();
            if (block.getLocation().isPresent()) {
                Region region = RegionUtils.getRegion((Location<World>)((Location)block.getLocation().get()));
                if (region != null && FlagUtils.isExcludedFromDestroy(region, type)) {
                    if (region.getFlag(EnumRegionFlag.DESTROY)) {
                        event.setCancelled(true);
                        MessageUtils.sendHotbarErrorMessage(player, RegionText.NO_PERMISSION_REGION.getValue());
                    }
                } else {
                    this.handleEvent((Cancellable)event, (Location<World>)((Location)block.getLocation().get()), player);
                }
            }
        }
    }

    private boolean handleEvent(Cancellable event, Location<World> location, Player player) {
        return RegionUtils.handleEvent(event, EnumRegionFlag.DESTROY, location, player, RegionEventType.LOCAL);
    }
}

