/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.RegionEventType;
import com.universeguard.utils.FlagUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagTrampleListener {
    @Listener
    public void onFarmlandBreak(ChangeBlockEvent.Place event) {
        BlockSnapshot source;
        if (!event.getTransactions().isEmpty() && (source = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getOriginal()).getState().getType().equals(BlockTypes.FARMLAND) && source.getLocation().isPresent()) {
            this.handleEvent((Cancellable)event, (Location<World>)((Location)source.getLocation().get()), null);
        }
    }

    @Listener
    public void onFieldsBreak(ChangeBlockEvent.Break event, @First Player player) {
        BlockSnapshot block;
        if (!event.getTransactions().isEmpty() && (block = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal()).getLocation().isPresent() && FlagUtils.isCrop(block.getState().getType())) {
            Location location = (Location)block.getLocation().get();
            this.handleEvent((Cancellable)event, (Location<World>)location, player);
        }
    }

    @Listener
    public void onFieldsDrop(SpawnEntityEvent event, @First LocatableBlock block) {
        if (event.getContext().containsKey(EventContextKeys.SPAWN_TYPE)) {
            SpawnType spawn = (SpawnType)event.getContext().get(EventContextKeys.SPAWN_TYPE).get();
            BlockType type = block.getBlockState().getType();
            if (spawn.equals(SpawnTypes.DROPPED_ITEM) && FlagUtils.isCrop(type)) {
                this.handleEvent((Cancellable)event, (Location<World>)block.getLocation(), null);
            }
        }
    }

    private boolean handleEvent(Cancellable event, Location<World> location, Player player) {
        return RegionUtils.handleEvent(event, EnumRegionFlag.TRAMPLE, location, player, RegionEventType.GLOBAL);
    }
}

