/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import com.flowpowered.math.vector.Vector3i;
import java.util.ArrayList;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;

public class Search
implements CommandExecutor {
    private final Main plugin;

    public Search(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            throw new CommandException(this.plugin.fromLegacy("Only players can run this command"));
        }
        final Player player = (Player)src;
        final ItemType itemType = (ItemType)args.getOne("ItemID").get();
        final Iterable loadedChunks = player.getWorld().getLoadedChunks();
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        final PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        final ArrayList contents = new ArrayList();
        player.sendMessage(this.plugin.fromLegacy("&eSearch has started, Please wait a moment for the results."));
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(new Runnable(){

            @Override
            public void run() {
                loadedChunks.forEach(chunk -> {
                    Vector3i min = chunk.getBlockMin();
                    Vector3i max = chunk.getBlockMax();
                    for (int x = min.getX(); x <= max.getX(); ++x) {
                        for (int y = min.getY(); y <= max.getY(); ++y) {
                            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                                BlockState block = chunk.getBlock(x, y, z);
                                if (!block.getType().getId().equals(itemType.getId())) continue;
                                Text.Builder send = Text.builder();
                                send.append(new Text[]{Search.this.plugin.fromLegacy("&6Block found: &7" + itemType.getTranslation().get() + " &6at x:&7" + x + " &6y:&7" + y + " &6z:&7" + z)});
                                send.onClick((ClickAction)TextActions.runCommand((String)("/tppos " + x + " " + y + " " + z)));
                                send.onHover((HoverAction)TextActions.showText((Text)Search.this.plugin.fromLegacy("Teleport to x:" + x + " y:" + y + " z:" + z)));
                                contents.add(send.build());
                            }
                        }
                    }
                });
                if (contents.isEmpty()) {
                    contents.add(Search.this.plugin.fromLegacy("No blocks found"));
                }
                paginationService.builder().title(Search.this.plugin.fromLegacy("Block Search")).contents((Iterable)contents).padding((Text)Text.of((String)"=")).sendTo((MessageReceiver)player);
            }
        });
        return CommandResult.success();
    }
}

