/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.render;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.UtilsKt;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;
import net.ndrei.teslacorelib.render.HudInfoLine;
import net.ndrei.teslacorelib.render.HudInfoRenderer$WhenMappings;
import net.ndrei.teslacorelib.render.IHudInfoProvider;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J@\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001e\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u00a8\u0006\u001e"}, d2={"Lnet/ndrei/teslacorelib/render/HudInfoRenderer;", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lnet/minecraft/tileentity/TileEntity;", "()V", "drawRectangle", "", "color", "Ljava/awt/Color;", "filled", "", "x", "", "y", "width", "height", "zTranslate", "render", "te", "z", "partialTicks", "", "destroyStage", "", "alpha", "renderText", "messages", "", "Lnet/ndrei/teslacorelib/render/HudInfoLine;", "scale", "shouldRender", "tesla-core-lib"})
public final class HudInfoRenderer
extends TileEntitySpecialRenderer<TileEntity> {
    public static final HudInfoRenderer INSTANCE;

    public void func_192841_a(@NotNull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        List<HudInfoLine> lines2;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        TileEntity tileEntity = te;
        if (!(tileEntity instanceof IHudInfoProvider)) {
            tileEntity = null;
        }
        IHudInfoProvider iHudInfoProvider = (IHudInfoProvider)tileEntity;
        if (iHudInfoProvider == null) {
            return;
        }
        IHudInfoProvider provider = iHudInfoProvider;
        if (!this.shouldRender(te)) {
            return;
        }
        EnumFacing side = this.field_147501_a.field_190057_j.field_178784_b;
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            BlockPos blockPos = te.func_174877_v();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"te.pos");
            side = UtilsKt.getFacingFromEntity(blockPos, this.field_147501_a.field_147560_j, this.field_147501_a.field_147558_l);
        }
        if (!(collection = (Collection)(lines2 = provider.getHudLines(side))).isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
            EnumFacing enumFacing = side;
            if (enumFacing != null) {
                switch (HudInfoRenderer$WhenMappings.$EnumSwitchMapping$0[enumFacing.ordinal()]) {
                    case 1: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 2: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 3: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
            super.func_190053_a(true);
            this.renderText(lines2, 1.0f);
            super.func_190053_a(false);
            GlStateManager.func_179121_F();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRender(TileEntity te) {
        if (this.field_147501_a.field_190057_j == null) return false;
        BlockPos blockPos = te.func_174877_v();
        RayTraceResult rayTraceResult = this.field_147501_a.field_190057_j;
        Intrinsics.checkExpressionValueIsNotNull((Object)rayTraceResult, (String)"this.rendererDispatcher.cameraHitResult");
        if (!Intrinsics.areEqual((Object)blockPos, (Object)rayTraceResult.func_178782_a())) return false;
        return true;
    }

    private final void renderText(List<HudInfoLine> messages, float scale) {
        FontRenderer font = FontRendererUtil.INSTANCE.getFontRenderer();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)0.01f);
        float magicNumber = 0.0075f;
        GlStateManager.func_179152_a((float)(magicNumber * scale), (float)(-magicNumber * scale), (float)magicNumber);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int blockSize = Math.round(scale * 0.9f / magicNumber);
        int padding = Math.round(scale * 0.05f / magicNumber);
        int height = 11;
        int logSize = messages.size();
        int y = -height * logSize - height / 2;
        for (HudInfoLine ctl : messages) {
            if (ctl.getBackground() != null) {
                this.drawRectangle(ctl.getBackground(), true, padding, y, blockSize, height, -0.03);
            }
            if (ctl.getPercent() > 0.0f && ctl.getPercentColor() != null) {
                double percent = Math.max(0.0, Math.min(1.0, (double)ctl.getPercent()));
                Color color = ctl.getPercentColor();
                if (color == null) {
                    Intrinsics.throwNpe();
                }
                this.drawRectangle(color, true, padding, y, (double)blockSize * percent, height, -0.02);
            }
            if (ctl.getBorder() != null) {
                this.drawRectangle(ctl.getBorder(), false, padding, y, blockSize, height, -0.01);
            }
            String line = font.func_78269_a(ctl.getText(), blockSize - 2);
            if (ctl.getAlignment() == HudInfoLine.TextAlignment.LEFT) {
                font.func_78276_b(line, padding + 1, y + 2, ctl.getColor() == null ? 0xFFFFFF : ctl.getColor().getRGB());
            } else {
                int textWidth = Math.min(font.func_78256_a(ctl.getText()), blockSize - 2);
                if (ctl.getAlignment() == HudInfoLine.TextAlignment.RIGHT) {
                    font.func_78276_b(line, padding + 1 + blockSize - 2 - textWidth, y + 2, ctl.getColor() == null ? 0xFFFFFF : ctl.getColor().getRGB());
                } else if (ctl.getAlignment() == HudInfoLine.TextAlignment.CENTER) {
                    font.func_78276_b(line, padding + 1 + (blockSize - 2 - textWidth) / 2, y + 2, ctl.getColor() == null ? 0xFFFFFF : ctl.getColor().getRGB());
                }
            }
            y += height;
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private final void drawRectangle(Color color, boolean filled, double x, double y, double width, double height, double zTranslate) {
        Tessellator tessellator;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder buffer = tessellator2.func_178180_c();
        if (!filled) {
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        } else {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(x, y + 0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + 0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)zTranslate);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private HudInfoRenderer() {
    }

    static {
        HudInfoRenderer hudInfoRenderer;
        INSTANCE = hudInfoRenderer = new HudInfoRenderer();
    }
}

