/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.base;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.command.base.PregenCommand;
import pregenerator.impl.misc.FilePos;

public abstract class BasePregenCommand
extends PregenCommand {
    Map<String, String> suggestions = new LinkedHashMap<String, String>();
    String[] descriptions;

    public BasePregenCommand(int amounts) {
        this.descriptions = new String[amounts];
    }

    public void addSuggestion(String command, String description) {
        this.suggestions.put(command, description);
    }

    public void addDescription(int index, String data) {
        this.descriptions[index] = data;
    }

    @Override
    public String[] getArgumentDescriptions() {
        return this.descriptions;
    }

    @Override
    public Map<String, String> getExamples() {
        return this.suggestions;
    }

    public static boolean isDimensionValid(int dim) {
        try {
            DimensionManager.getProviderType((int)dim);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getDimension(CommandContainer container, String dimension) {
        if (dimension == null || dimension.isEmpty() || dimension.equals("~")) {
            return container.getPlayerDimension();
        }
        return Integer.parseInt(dimension);
    }

    public static FilePos getChunkPos(String xPos, String zPos, FilePos playerPos) {
        playerPos = playerPos.toChunkPos();
        return new FilePos(BasePregenCommand.getNumber(xPos, playerPos.x), BasePregenCommand.getNumber(zPos, playerPos.z));
    }

    public static FilePos getBlockPos(String xPos, String zPos, FilePos playerPos) {
        return new FilePos(BasePregenCommand.getNumber(xPos.replace("b", ""), playerPos.x), BasePregenCommand.getNumber(zPos.replace("b", ""), playerPos.z));
    }

    public static FilePos applySpawn(String xPos, String zPos, FilePos original, FilePos worldSpawn) {
        int x = original.x;
        int z = original.z;
        if (xPos.startsWith("s")) {
            x += worldSpawn.x;
        }
        if (zPos.startsWith("s")) {
            z += worldSpawn.z;
        }
        return new FilePos(x, z);
    }

    public static int getNumber(String s, int offset) {
        if (s.startsWith("s") && (s = s.substring(1)).isEmpty()) {
            return 0;
        }
        if (!s.startsWith("~")) {
            if (!s.startsWith("b")) {
                return Integer.parseInt(s);
            }
            return Integer.parseInt(s.substring(1)) / 16;
        }
        if (s.length() > 1) {
            if ((s = s.substring(1)).startsWith("b")) {
                return offset + Integer.parseInt(s.substring(1)) / 16;
            }
            return offset + Integer.parseInt(s);
        }
        return offset;
    }

    public static int parseNumber(String s, int defaultNumber) {
        if (s == null || s.isEmpty()) {
            return defaultNumber;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return defaultNumber;
        }
    }

    public static int clamp(int current, int min, int max) {
        return current < min ? min : (current > max ? max : current);
    }

    public static int getGenType(String type) {
        if (type == null || type.isEmpty()) {
            return 0;
        }
        if (type.equalsIgnoreCase("square")) {
            return 0;
        }
        if (type.equalsIgnoreCase("circle")) {
            return 1;
        }
        return 0;
    }

    public static int getProcessRule(String rule) {
        if (rule == null || rule.isEmpty()) {
            return 1;
        }
        if (rule.equalsIgnoreCase("TerrainOnly")) {
            return 0;
        }
        if (rule.equalsIgnoreCase("PostProcessingOnly")) {
            return 2;
        }
        if (rule.equalsIgnoreCase("BlockingPostProcessing")) {
            return 3;
        }
        if (rule.equalsIgnoreCase("Retrogen")) {
            return 4;
        }
        return 1;
    }

    public static long getFullCount(int xMin, int zMin, int xMax, int zMax) {
        int xSize = xMax - xMin;
        int zSize = zMax - zMin;
        return xSize * xSize + zSize * zSize;
    }

    public static int getRingCount(int min, int max, boolean circle) {
        int minDia = min * 2;
        int maxDia = max * 2;
        if (circle) {
            return (int)((double)maxDia * Math.PI - (double)minDia * Math.PI);
        }
        return maxDia * maxDia - minDia * minDia;
    }

    public static int getFullCount(int radius, boolean circle) {
        int dia = radius * 2;
        return circle ? (int)((double)dia * Math.PI) : dia * dia;
    }
}

