/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiAirConditionerOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.Itemss;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AirConUpgradeHandler
extends IUpgradeRenderHandler.SimpleToggleableRenderHandler {
    private static final int MAX_AC = 20;
    public static int deltaTemp;
    private static int currentAC;
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat acStat;

    @Override
    public String getUpgradeName() {
        return "airConditioning";
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.AIR_CONDITIONING)};
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.CHEST;
    }

    @Override
    public IOptionPage getGuiOptionsPage() {
        return new GuiAirConditionerOptions(this);
    }

    @Override
    public void update(EntityPlayer player, int rangeUpgrades) {
        super.update(player, rangeUpgrades);
        if ((player.field_70170_p.func_82737_E() & 3L) == 0L) {
            if (currentAC < deltaTemp) {
                ++currentAC;
            } else if (currentAC > deltaTemp) {
                --currentAC;
            }
        }
        if (this.acStat.isClicked()) {
            int ac = MathHelper.func_76125_a((int)currentAC, (int)-20, (int)20);
            String bar = (ac < 0 ? TextFormatting.BLUE : TextFormatting.GOLD) + Strings.repeat((String)"|", (int)Math.abs(ac)) + TextFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(20 - Math.abs(ac)));
            this.acStat.setTitle(TextFormatting.YELLOW + "A/C: " + bar);
            this.acStat.setBackGroundColor(ac < 0 ? 805339391 : (ac == 0 ? 0x3000AA00 : 822071296));
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.acStat == null) {
            this.acStat = new GuiAnimatedStat(null, "", GuiAnimatedStat.StatIcon.NONE, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.airConStat);
            this.acStat.setMinDimensionsAndReset(0, 0);
        }
        return this.acStat;
    }

    @Override
    public void onResolutionChanged() {
        this.acStat = null;
    }

    static {
        currentAC = 0;
    }
}

