/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.minigun;

import java.util.Random;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class Minigun {
    public static final double MAX_GUN_SPEED = 0.4;
    private static final double MAX_GUN_YAW_CHANGE = 10.0;
    private static final double MAX_GUN_PITCH_CHANGE = 10.0;
    private final boolean requiresTarget;
    private double minigunSpeed;
    private int minigunTriggerTimeOut;
    private int minigunSoundCounter = -1;
    private final Random rand = new Random();
    private double minigunRotation;
    private double oldMinigunRotation;
    public double minigunYaw;
    public double oldMinigunYaw;
    public double minigunPitch;
    public double oldMinigunPitch;
    private final RenderProgressingLine minigunFire = new RenderProgressingLine().setProgress(1.0f);
    private boolean sweeping;
    private double sweepingProgress;
    private boolean gunAimedAtTarget;
    private IPressurizable pressurizable;
    private int airUsage;
    protected ItemStack minigunStack = ItemStack.field_190927_a;
    private ItemStack ammoStack = ItemStack.field_190927_a;
    protected EntityPlayer player;
    protected World world;
    private EntityLivingBase attackTarget;

    public Minigun(boolean requiresTarget) {
        this.requiresTarget = requiresTarget;
    }

    public Minigun setPressurizable(IPressurizable pressurizable, int airUsage) {
        this.pressurizable = pressurizable;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setItemStack(@Nonnull ItemStack stack) {
        this.minigunStack = stack;
        return this;
    }

    public Minigun setAmmoStack(@Nonnull ItemStack ammoStack) {
        this.ammoStack = ammoStack;
        return this;
    }

    @Nonnull
    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public Minigun setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Minigun setWorld(World world) {
        this.world = world;
        return this;
    }

    public World getWorld() {
        return this.world;
    }

    public Minigun setAttackTarget(EntityLivingBase entity) {
        this.attackTarget = entity;
        return this;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(@Nonnull ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(SoundEvent var1, float var2, float var3);

    protected int getAmmoColor(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? -13553359 : Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1);
    }

    public Object getSoundSource() {
        return this.player;
    }

    public double getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(double minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public int getMinigunSoundCounter() {
        return this.minigunSoundCounter;
    }

    public void setMinigunSoundCounter(int minigunSoundCounter) {
        this.minigunSoundCounter = minigunSoundCounter;
    }

    public double getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(double minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public double getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(double oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean tryFireMinigun(Entity target) {
        boolean lastShotOfAmmo = false;
        if (!this.ammoStack.func_190926_b() && (this.pressurizable == null || this.pressurizable.getPressure(this.minigunStack) > 0.0f)) {
            this.setMinigunTriggerTimeOut(Math.max(10, this.getMinigunSoundCounter()));
            if (this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget)) {
                RayTraceResult rtr = null;
                ItemGunAmmo ammoItem = (ItemGunAmmo)this.ammoStack.func_77973_b();
                if (!this.requiresTarget) {
                    rtr = PneumaticCraftUtils.getMouseOverServer((EntityLivingBase)this.player, this.getRange());
                    target = rtr.field_72308_g;
                }
                if (this.pressurizable != null) {
                    int usage = (int)Math.ceil((float)this.airUsage * ammoItem.getAirUsageMultiplier(this, this.ammoStack));
                    usage += this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE);
                    if (this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED) > 0) {
                        usage *= this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED) + 1;
                    }
                    this.pressurizable.addAir(this.minigunStack, -usage);
                }
                int roundsUsed = 1;
                if (target != null) {
                    if (this.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY) == 0 || !this.securityProtectedTarget(target)) {
                        roundsUsed = ammoItem.onTargetHit(this, this.ammoStack, target);
                    }
                } else if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
                    roundsUsed = ammoItem.onBlockHit(this, this.ammoStack, rtr.func_178782_a(), rtr.field_178784_b, rtr.field_72307_f);
                }
                int ammoCost = roundsUsed * ammoItem.getAmmoCost(this.ammoStack);
                lastShotOfAmmo = this.ammoStack.func_96631_a(ammoCost, this.rand, this.player instanceof EntityPlayerMP ? (EntityPlayerMP)this.player : null);
            }
        }
        return lastShotOfAmmo;
    }

    private boolean securityProtectedTarget(Entity target) {
        if (target instanceof EntityTameable) {
            return ((EntityTameable)target).func_70902_q() != null;
        }
        if (target instanceof EntityDrone) {
            return ((EntityDrone)target).getOwner().func_110124_au().equals(this.getPlayer().func_110124_au());
        }
        return target instanceof EntityPlayer;
    }

    public void update(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && this.attackTarget.field_70128_L) {
            this.attackTarget = null;
        }
        if (!this.world.field_72995_K) {
            this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
            this.setAmmoColorStack(this.ammoStack);
            if (this.getMinigunTriggerTimeOut() > 0) {
                this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
                if (this.getMinigunSpeed() == 0.0) {
                    this.playSound(Sounds.HUD_INIT, 3.0f, 0.9f);
                }
            }
            if (this.getMinigunSoundCounter() == 0 && this.getMinigunTriggerTimeOut() == 0) {
                this.playSound(Sounds.MINIGUN_STOP, 3.0f, 0.5f);
                this.setMinigunSoundCounter(-1);
            }
        }
        if (this.isMinigunActivated()) {
            double speedBonus = (double)this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED) * 0.0033;
            double lastSpeed = this.getMinigunSpeed();
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01 + speedBonus, 0.4));
            if (this.getMinigunSpeed() > lastSpeed && this.getMinigunSpeed() >= 0.4 && !this.world.field_72995_K) {
                NetworkHandler.sendToDimension(new PacketPlayMovingSound(MovingSounds.Sound.MINIGUN, this.getSoundSource()), this.world.field_73011_w.getDimension());
            }
        } else {
            this.setMinigunSpeed(Math.max(0.0, this.getMinigunSpeed() - 0.003));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        double targetPitch = 0.0;
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.field_70165_t;
            double deltaZ = posZ - this.attackTarget.field_70161_v;
            double targetYaw = deltaX >= 0.0 && deltaZ < 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 : (deltaX >= 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 90.0 : (deltaX < 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 + 180.0 : Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 270.0));
            if (targetYaw - this.minigunYaw > 180.0) {
                targetYaw -= 360.0;
            } else if (this.minigunYaw - targetYaw > 180.0) {
                targetYaw += 360.0;
            }
            targetPitch = Math.toDegrees(Math.atan((posY - this.attackTarget.field_70163_u - (double)(this.attackTarget.field_70131_O / 2.0f)) / PneumaticCraftUtils.distBetween(posX, posZ, this.attackTarget.field_70165_t, this.attackTarget.field_70161_v)));
            this.minigunPitch = this.moveToward(this.minigunPitch, targetPitch, 10.0);
            this.minigunYaw = this.minigunPitch < -80.0 || this.minigunPitch > 80.0 ? targetYaw : this.moveToward(this.minigunYaw, targetYaw, 10.0);
            this.gunAimedAtTarget = this.minigunYaw == targetYaw && this.minigunPitch == targetPitch;
        } else if (this.isSweeping()) {
            this.minigunYaw -= Math.cos(this.sweepingProgress) * 22.0;
            this.sweepingProgress += 0.05;
            this.minigunYaw += Math.cos(this.sweepingProgress) * 22.0;
            this.minigunPitch = this.moveToward(this.minigunPitch, targetPitch, 10.0);
        }
        if (!this.world.field_72995_K && this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget && this.attackTarget != null) && this.getMinigunSoundCounter() <= 0) {
            this.setMinigunSoundCounter(20);
        }
        if (this.getMinigunSoundCounter() > 0) {
            this.setMinigunSoundCounter(this.getMinigunSoundCounter() - 1);
        }
    }

    private double moveToward(double val, double target, double amount) {
        val = val > target ? Math.max(val - amount, target) : Math.min(val + amount, target);
        return val;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(double x, double y, double z, double gunRadius) {
        if (this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && this.gunAimedAtTarget && this.attackTarget != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            GlStateManager.func_179090_x();
            GL11.glEnable((int)2852);
            RenderUtils.glColorHex(0xFF000000 | this.getAmmoColor());
            for (int i = 0; i < 5; ++i) {
                int stipple = 0xFFFF & ~(2 << this.rand.nextInt(16));
                GL11.glLineStipple((int)4, (short)((short)stipple));
                Vec3d vec = new Vec3d(this.attackTarget.field_70165_t - x, this.attackTarget.field_70163_u - y, this.attackTarget.field_70161_v - z).func_72432_b();
                this.minigunFire.startX = x + vec.field_72450_a * gunRadius;
                this.minigunFire.startY = y + vec.field_72448_b * gunRadius;
                this.minigunFire.startZ = z + vec.field_72449_c * gunRadius;
                this.minigunFire.endX = this.attackTarget.field_70165_t + this.rand.nextDouble() - 0.5;
                this.minigunFire.endY = this.attackTarget.field_70163_u + (double)(this.attackTarget.field_70131_O / 2.0f) + this.rand.nextDouble() - 0.5;
                this.minigunFire.endZ = this.attackTarget.field_70161_v + this.rand.nextDouble() - 0.5;
                this.minigunFire.render();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2852);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public int getUpgrades(IItemRegistry.EnumUpgrade upgrade) {
        return 0;
    }

    public double getRange() {
        double mul = this.getAmmoStack().func_77973_b() instanceof ItemGunAmmo ? (double)((ItemGunAmmo)this.ammoStack.func_77973_b()).getRangeMultiplier(this.ammoStack) : 1.0;
        return (double)(ConfigHandler.minigun.baseRange + 5 * this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE)) * mul;
    }

    public boolean dispenserWeightedPercentage(int basePct) {
        return this.dispenserWeightedPercentage(basePct, 0.1f);
    }

    public boolean dispenserWeightedPercentage(int basePct, float dispenserWeight) {
        return (float)this.getWorld().field_73012_v.nextInt(100) < (float)basePct * (1.0f + (float)this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) * dispenserWeight);
    }
}

