/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.configs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class GSConfigCore {
    public static Configuration config;
    public static boolean enableCheckVersion;
    public static boolean enableOresGeneration;
    public static boolean enableDungeonsGeneration;
    public static boolean enableNewMenu;
    public static boolean enableSkyOverworld;
    public static boolean enableGSMars;
    public static boolean enableOverworldOres;
    public static int idSolarRadiation;
    public static int idAntiRadiation;
    public static int speedTimeTravel;
    public static int guiIDGuideBook;
    public static boolean enableMethaneParticle;
    public static boolean enableUnreachable;
    public static boolean enableHardMode;
    public static boolean enableWorldEngine;
    public static boolean enablePlateOreDict;
    public static boolean enableSpaceSuitHUD;
    public static boolean enableRadiationSystem;
    public static boolean enablePressureSystem;
    public static boolean enableAdvancedRocketCraft;
    public static boolean enableAdvancedThermalSystem;
    public static String spacesuit_pos;
    public static boolean enableDebug;
    public static String[] radiation_armor;
    public static String keyOverrideToggleHelmet;
    public static String keyOverrideToggleChest;
    public static String keyOverrideToggleLegs;
    public static String keyOverrideToggleBoots;
    public static int keyOverrideToggleHelmetI;
    public static int keyOverrideToggleChestI;
    public static int keyOverrideToggleLegsI;
    public static int keyOverrideToggleBootsI;

    public GSConfigCore(File file) {
        config = new Configuration(file);
        GSConfigCore.syncConfig(true);
    }

    private static void setConfigBoolean(Property prop, List<String> propOrder, String category, String confname, String desc, boolean conf, boolean def) {
        prop = config.get(category, confname, def);
        prop.setComment(desc);
        prop.setLanguageKey("gs.configgui." + confname).setRequiresMcRestart(true);
        conf = prop.getBoolean(def);
        propOrder.add(prop.getName());
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            propOrder.clear();
            if (!GSConfigCore.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "enableCheckVersion", true);
            prop.setComment("Enable/Disable Check Version.");
            prop.setLanguageKey("gc.configgui.enableCheckVersion").setRequiresMcRestart(false);
            enableCheckVersion = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableAdvancedRocketCraft", true);
            prop.setComment("Enable/Disable advanced craft for rocket tier 2-3.");
            prop.setLanguageKey("gc.configgui.enableAdvancedRocketCraft").setRequiresMcRestart(true);
            enableAdvancedRocketCraft = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableAdvancedThermalSystem", true);
            prop.setComment("Enable/Disable advanced thermal system on celestial bodies.");
            prop.setLanguageKey("gc.configgui.enableAdvancedThermalSystem").setRequiresMcRestart(false);
            enableAdvancedThermalSystem = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableOverworldOres", true);
            prop.setComment("Enable/Disable Generation Ores on Overworld.");
            prop.setLanguageKey("gc.configgui.enableOverworldOres").setRequiresMcRestart(false);
            enableOverworldOres = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableOresGeneration", true);
            prop.setComment("Enable/Disable Generation Ores on Planets/Moon (Global Config).");
            prop.setLanguageKey("gc.configgui.enableOresGeneration").setRequiresMcRestart(false);
            enableOresGeneration = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableDungeonsGeneration", true);
            prop.setComment("Enable/Disable Dungeons Generation on Planets/Moon (Global Config).");
            prop.setLanguageKey("gc.configgui.enableDungeonsGeneration").setRequiresMcRestart(false);
            enableDungeonsGeneration = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableRadiationSystem", true);
            prop.setComment("Enable/Disable solar radiation system.");
            prop.setLanguageKey("gc.configgui.enableRadiationSystem").setRequiresMcRestart(false);
            enableRadiationSystem = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enablePressureSystem", true);
            prop.setComment("Enable/Disable atmosphere pressure system.");
            prop.setLanguageKey("gc.configgui.enablePressureSystem").setRequiresMcRestart(false);
            enablePressureSystem = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableNewMenu", true);
            prop.setComment("Enable/Disable new Main Menu.");
            prop.setLanguageKey("gc.configgui.enableNewMenu").setRequiresMcRestart(false);
            enableNewMenu = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableMethaneParticle", true);
            prop.setComment("Enable/Disable Methane Particles.");
            prop.setLanguageKey("gc.configgui.enableMethaneParticle").setRequiresMcRestart(false);
            enableMethaneParticle = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableGSMars", true);
            prop.setComment("Enable/Disable Mars with new generations.");
            prop.setLanguageKey("gc.configgui.enableGCMars").setRequiresMcRestart(true);
            enableGSMars = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "idSolarRadiation", idSolarRadiation);
            prop.setComment("ID Potion 'Solar Radiation'");
            prop.setLanguageKey("gc.configgui.idSolarRadiation").setRequiresMcRestart(false);
            idSolarRadiation = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "idAntiRadiation", idAntiRadiation);
            prop.setComment("ID Potion 'Anti Radiation'");
            prop.setLanguageKey("gc.configgui.idAntiRadiation").setRequiresMcRestart(false);
            idAntiRadiation = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "speedTimeTravel", speedTimeTravel);
            prop.setComment("Time Travel speed factor.");
            prop.setLanguageKey("gc.configgui.speedTimeTravel").setRequiresMcRestart(false);
            speedTimeTravel = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "guiIDGuideBook", guiIDGuideBook);
            prop.setComment("ID gui for Guide Book.");
            prop.setLanguageKey("gc.configgui.guiIDGuideBook").setRequiresMcRestart(false);
            guiIDGuideBook = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "enableUnreachable", true);
            prop.setComment("Enable/Disable Unreachable Planets/Moons");
            prop.setLanguageKey("gc.configgui.enableUnreachable").setRequiresMcRestart(true);
            enableUnreachable = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableHardMode", true);
            prop.setComment("Enable/Disable Hard Mode (Death of Atm. Pressure)");
            prop.setLanguageKey("gc.configgui.enableHardMode").setRequiresMcRestart(true);
            enableHardMode = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableWorldEngine", true);
            prop.setComment("Enable/Disable 'World Engine' - advanced world generation");
            prop.setLanguageKey("gc.configgui.enableWorldEngine").setRequiresMcRestart(true);
            enableWorldEngine = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enablePlateOreDict", true);
            prop.setComment("Enable/Disable register OreDict for GC Compressed Plate");
            prop.setLanguageKey("gc.configgui.enablePlateOreDict").setRequiresMcRestart(false);
            enablePlateOreDict = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("client", "enableSpaceSuitHUD", true);
            prop.setComment("Enable/Disable space suit HUD.");
            prop.setLanguageKey("gc.configgui.enableSpaceSuitHUD").setRequiresMcRestart(false);
            enableSpaceSuitHUD = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "spacesuit_pos", spacesuit_pos);
            prop.setComment("Set HUD position. (up or top, center, down or bottom)");
            prop.setLanguageKey("gc.configgui.spacesuit_pos").setRequiresMcRestart(false);
            spacesuit_pos = prop.getString();
            propOrder.add(prop.getName());
            prop = config.get("development", "enableDebug", false);
            prop.setComment("Enable/Disable Debug mode");
            prop.setLanguageKey("gc.configgui.enableDebug").setRequiresMcRestart(false);
            enableDebug = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Radiation and Pressure Armor List", new String[]{"ic2:quantum_helmet", "ic2:quantum_chestplate", "ic2:quantum_leggings", "ic2:quantum_boots"});
            prop.setComment("List armor with protect radiation and pressure. Format: 'modid:item' ");
            prop.setLanguageKey("gc.configgui.armorIDs").setRequiresMcRestart(false);
            radiation_armor = prop.getStringList();
            propOrder.add(prop.getName());
            prop = config.get("keybindings_initial", "Toggle Helmet Key", "KEY_F");
            prop.setComment("Leave 'KEY_' value, adding the intended keyboard character to replace the letter. Values 0-9 and A-Z are accepted");
            prop.setLanguageKey("gc.configgui.keyOverrideToggleHelmet").setRequiresMcRestart(false);
            keyOverrideToggleHelmet = prop.getString();
            keyOverrideToggleHelmetI = GSConfigCore.parseKeyValue(keyOverrideToggleHelmet);
            propOrder.add(prop.getName());
            prop = config.get("keybindings_initial", "Toggle Chestplate Key", "KEY_G");
            prop.setComment("Leave 'KEY_' value, adding the intended keyboard character to replace the letter. Values 0-9 and A-Z are accepted");
            prop.setLanguageKey("gc.configgui.keyOverrideToggleChest").setRequiresMcRestart(false);
            keyOverrideToggleChest = prop.getString();
            keyOverrideToggleChestI = GSConfigCore.parseKeyValue(keyOverrideToggleChest);
            propOrder.add(prop.getName());
            prop = config.get("keybindings_initial", "Toggle Legs Key", "KEY_H");
            prop.setComment("Leave 'KEY_' value, adding the intended keyboard character to replace the letter. Values 0-9 and A-Z are accepted");
            prop.setLanguageKey("gc.configgui.keyOverrideToggleLegs").setRequiresMcRestart(false);
            keyOverrideToggleLegs = prop.getString();
            keyOverrideToggleLegsI = GSConfigCore.parseKeyValue(keyOverrideToggleLegs);
            propOrder.add(prop.getName());
            prop = config.get("keybindings_initial", "Toggle Boots Key", "KEY_J");
            prop.setComment("Leave 'KEY_' value, adding the intended keyboard character to replace the letter. Values 0-9 and A-Z are accepted");
            prop.setLanguageKey("gc.configgui.keyOverrideToggleBoots").setRequiresMcRestart(false);
            keyOverrideToggleBoots = prop.getString();
            keyOverrideToggleBootsI = GSConfigCore.parseKeyValue(keyOverrideToggleBoots);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            config.save();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"GalaxySpace (Core) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("controls")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("compatibility")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("server")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("entities")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("keybindings_initial")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("development")).getChildElements());
        return list;
    }

    private static int parseKeyValue(String key) {
        if (key.equals("KEY_A")) {
            return 30;
        }
        if (key.equals("KEY_B")) {
            return 48;
        }
        if (key.equals("KEY_C")) {
            return 46;
        }
        if (key.equals("KEY_D")) {
            return 32;
        }
        if (key.equals("KEY_E")) {
            return 18;
        }
        if (key.equals("KEY_F")) {
            return 33;
        }
        if (key.equals("KEY_G")) {
            return 34;
        }
        if (key.equals("KEY_H")) {
            return 35;
        }
        if (key.equals("KEY_I")) {
            return 23;
        }
        if (key.equals("KEY_J")) {
            return 36;
        }
        if (key.equals("KEY_K")) {
            return 37;
        }
        if (key.equals("KEY_L")) {
            return 38;
        }
        if (key.equals("KEY_M")) {
            return 50;
        }
        if (key.equals("KEY_N")) {
            return 49;
        }
        if (key.equals("KEY_O")) {
            return 24;
        }
        if (key.equals("KEY_P")) {
            return 25;
        }
        if (key.equals("KEY_Q")) {
            return 16;
        }
        if (key.equals("KEY_R")) {
            return 19;
        }
        if (key.equals("KEY_S")) {
            return 31;
        }
        if (key.equals("KEY_T")) {
            return 20;
        }
        if (key.equals("KEY_U")) {
            return 22;
        }
        if (key.equals("KEY_V")) {
            return 47;
        }
        if (key.equals("KEY_W")) {
            return 17;
        }
        if (key.equals("KEY_X")) {
            return 45;
        }
        if (key.equals("KEY_Y")) {
            return 21;
        }
        if (key.equals("KEY_Z")) {
            return 44;
        }
        if (key.equals("KEY_1")) {
            return 2;
        }
        if (key.equals("KEY_2")) {
            return 3;
        }
        if (key.equals("KEY_3")) {
            return 4;
        }
        if (key.equals("KEY_4")) {
            return 5;
        }
        if (key.equals("KEY_5")) {
            return 6;
        }
        if (key.equals("KEY_6")) {
            return 7;
        }
        if (key.equals("KEY_7")) {
            return 8;
        }
        if (key.equals("KEY_8")) {
            return 9;
        }
        if (key.equals("KEY_9")) {
            return 10;
        }
        if (key.equals("KEY_0")) {
            return 11;
        }
        GCLog.severe((String)("Failed to parse keyboard key: " + key + "... Use values A-Z or 0-9"));
        return 0;
    }

    static {
        idSolarRadiation = 29;
        idAntiRadiation = 30;
        speedTimeTravel = 1;
        guiIDGuideBook = 1001;
        spacesuit_pos = "center";
    }
}

